/*
 * ui.c - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */ 
#define UI_NAME "msa_example"
#include "ui.h"

/** message **/
const char* img_resp = "\
<TransitData>\
<TargetID>db</TargetID>\
<SourceID>ui</SourceID>\
<Content>\
<Request class=\"binaryData\" function=\"getBinaryData\">\
<Params>\
</Params>\
</Request>\
</Content>\
</TransitData>";

/**
 * @brief initialization
 * @param module - user interface module info
 * @return 0
**/
extern int msa_module_init(msa_module *module)
{
    g_print("driver %s: init!", UI_NAME);   
// !!!     
    module->name = UI_NAME;//g_strndup(UI_NAME, 9);
    module->send = ui_got_response;
    module->module_start = ui_start;
    module->status = 1;
    module->state = 1;
    return 0;
}

/**
 * @brief
 * @param
 * @return
**/
static void ui_start(gpointer _data, gpointer list_drv, int argc, char* argv[])
{
    g_print("UI START ()");

    /* DRIVERS */
    kernel = (msa_module*)_data;
    GList* list = (GList*)list_drv;
    GList* node;
 
    /* GTK INIT */
    gtk_init(NULL, NULL);
    g_set_application_name(STR_PROG);
    
    /* CREATE UI DATA */
    ui_data = g_new0(UIdata, 1);
    ui_data->drivers = list_drv;
    ui_data->num_srvs =  g_list_length(list);
    ui_data->table_imgs = g_hash_table_new(g_str_hash, g_str_equal); 
    ui_data->box_friends_profile = NULL;
    
    /* CREATE UI FORMS */
    ui_init();
}

/**
 * @brief
 * @param
 * @return
**/
int ui_got_response(xmlDocPtr response, xmlDocPtr* answer, msa_module* ui_info_not_use)
{
        gchar* class_name = NULL;
        gchar* func = NULL;
        GSource* source = g_timeout_source_new(TIMEOUT);
        //hildon_gtk_window_set_progress_indicator (ui_data->window, 0);
        
        if (get_function_from_response(response, &class_name, &func) == 0 ) {
            g_print("UI GOT RESPONSE: %s -> %s", class_name, func);
            if (strcmp(class_name, SETTINGS) == 0) {
                /* SETTINGS */
                if (strcmp(func, GET_SETTINGS) == 0) {
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_settings), (gpointer)response, NULL);
                }  
            } else if (strcmp(class_name, PROFILE) == 0) {
                /* PROFILE */
                if (strcmp(func, GET_PROFILE) == 0) {     
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_profile), (gpointer)response, NULL);
                } else if (strcmp(func, GET_FRIENDS_PROFILE) == 0) {    
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_friends_profile), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, FRIENDS) == 0) {
                /* FRIENDS */
                if (strcmp(func, GET_FRIENDSLIST) == 0) {     
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_friends), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, MESSAGES) == 0) {
                /* MESSAGES */
                if (strcmp(func, GET_INBOX) == 0) {
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_messages), (gpointer)response, NULL);
                }
                if (strcmp(func, GET_OUTBOX) == 0) {    
                    g_source_set_callback(source, G_CALLBACK(ui_driver_get_messages), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, SYSTEM_MESSAGES) == 0) {
                /* SYSTEM MESSAGES */
                if (strcmp(func, ERROR_MESSAGE) == 0) {     
                    g_source_set_callback(source, G_CALLBACK(ui_show_error), (gpointer)response, NULL);
                } 
                if (strcmp(func, INFO_MESSAGE) == 0) {        
                    g_source_set_callback(source, G_CALLBACK(ui_show_info), (gpointer)response, NULL);
                }
                if (strcmp(func, CAPTCHA_MSG) == 0) {        
                    g_source_set_callback(source, G_CALLBACK(ui_show_captcha), (gpointer)response, NULL);
                }
            } else if (strcmp(class_name, CLASS_BINARY_DATA) == 0) {
                /* BINARY DATA */
                if (strcmp(func, GET_BINARY_DATA) == 0) {
                    g_source_set_callback(source, G_CALLBACK(ui_show_img), (gpointer)response, NULL);    
                } 
            }
        }

    g_free(func);
    g_free(class_name);
    g_source_attach(source, NULL);
    ui_data->source_time = source;
    *answer = NULL;

    return 0;
}

/**
 * @brief
 * @param
 * @return
**/
gboolean ui_driver_get_profile(gpointer request)
{
    g_debug("ui_driver_get_profile: START");

    if (ui_data->ui_request != NULL) {
        xmlFreeDoc(ui_data->ui_request);
    }
    ui_data->ui_request = xmlCopyDoc((xmlDocPtr)request,1);
 
    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params", (xmlDocPtr)request);
    xmlNodePtr node;
 
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
	    node = obj->nodesetval->nodeTab[0];
	    if (node->children != NULL){
	    	node = node->children;
	    } else return FALSE;
    } else return FALSE;

// !!!
  	xmlXPathFreeObject(obj);	
  	obj = NULL;

    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_profile));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_left = gtk_vbox_new(TRUE, 0);
    GtkWidget* vbox_edit = gtk_vbox_new(TRUE, 0);
    GtkWidget* hbox_edit = gtk_hbox_new(FALSE, 0);
    GtkWidget* hbox = gtk_hbox_new(FALSE, 0);
    GtkWidget* panarea = hildon_pannable_area_new();
    hildon_pannable_area_add_with_viewport(panarea, hbox_edit);
    int i = 0;
    GtkWidget* detail;
    GtkWidget* label;
    xmlNodePtr cont; 
    while(node != NULL)
    {
        gchar* type = (gchar*)node->name;
        if (!strcmp(type, TYPE_STRNG)) {
// !!!
            gchar* prop_val = xmlGetProp(node, "name");
            label = ui_init_label(prop_val);
            g_free(prop_val);
            
            detail = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
            gtk_entry_set_text(GTK_ENTRY(detail), (gchar*)xmlNodeGetContent(node));
            gtk_box_pack_start(GTK_BOX(vbox_left), label, TRUE, TRUE, 0);        
            gtk_box_pack_start(GTK_BOX(vbox_edit), detail, TRUE, TRUE, 0);        
        } else if (!strcmp(type, TYPE_IMAGE)) {
            cont = node;
        } else if (!strcmp(type, TYPE_SELCT)) {
            gchar* prop_val = xmlGetProp(node, "name");
            label = ui_init_label(prop_val);
            g_free(prop_val);
            
            GtkWidget *selector = hildon_touch_selector_new_text ();
            detail = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
            hildon_picker_button_set_selector(detail, selector);
            xmlNodePtr select = node->children;
            int i = 0;
            int n = 0;
            gchar *str_value;
            while (select != NULL) {
                str_value = (gchar*)xmlGetProp(select, "selected");	
		        if (!strcmp(str_value, "1")) {
                    n = i;
                }
                g_free(str_value);
    		    str_value = (gchar*)xmlNodeGetContent(select);							
    		    hildon_touch_selector_append_text(selector, str_value);
	    	    g_free(str_value);
                select = select->next;
                i++;
            }
            hildon_touch_selector_set_active(selector, 0, n);
            //hildon_picker_button_set_done_button_text(detail, str_value);
// !!!
            prop_val = xmlGetProp(node, "name");
            gtk_widget_set_name(GTK_WIDGET(selector), prop_val);
            g_free(prop_val);      
            
            hildon_button_set_value_alignment(detail, 0, 0.5);
            hildon_button_set_title_alignment(detail, 0, 0.5);
            g_signal_connect(G_OBJECT(detail), "value-changed", G_CALLBACK(callback_combo_changed), (gpointer)xmlGetProp(node, "name"));
            gtk_box_pack_start(GTK_BOX(vbox_left), label, TRUE, TRUE, 0);
            gtk_box_pack_start(GTK_BOX(vbox_edit), detail, FALSE, FALSE, 0);
            gtk_button_set_relief(GTK_WIDGET(detail), GTK_RELIEF_NONE);
        } else if (!strcmp(type, TYPE_DATE)) {
            gchar* prop_val = (gchar*) xmlGetProp(node, "name");
            label = ui_init_label(prop_val);
            g_free(prop_val);
            
// !!            detail = ui_init_date_chooser(xmlGetProp(node, "name"), (gchar*)xmlNodeGetContent(node));
            detail = ui_init_date_chooser(NULL, (gchar*)xmlNodeGetContent(node));
            gtk_button_set_relief(GTK_WIDGET(detail), GTK_RELIEF_NONE);
            hildon_button_set_value_alignment(detail, 0, 0.5);
            hildon_button_set_title_alignment(detail, 0, 0.5);
            gtk_box_pack_start(GTK_BOX(vbox_left), label, TRUE, TRUE, 0);        
            gtk_box_pack_start(GTK_BOX(vbox_edit), detail, FALSE, FALSE, 0); 
        }
        node = node->next;
    }    
    guchar* buff; 
    guchar* undecoded;
    GdkPixbuf* pixbuff;  
    int size;    
    undecoded = (gchar*)xmlNodeGetContent(cont);
    buff = g_base64_decode(undecoded, &size);
    GdkPixbufLoader* pbloader;
    pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
    gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
    pixbuff = gdk_pixbuf_loader_get_pixbuf(pbloader);
    int height = gdk_pixbuf_get_height(pixbuff);
    if (height > MAX_HEIGHT_PHOTO) {
        int width = gdk_pixbuf_get_width(pixbuff) * MAX_HEIGHT_PHOTO / height;
        height = MAX_HEIGHT_PHOTO;
        GdkPixbuf * npixbuff = gdk_pixbuf_scale_simple(pixbuff, width, height, GDK_INTERP_BILINEAR);
        g_object_unref(pixbuff);
        pixbuff = npixbuff;
    }
    GtkWidget* image = gtk_image_new_from_pixbuf(pixbuff);
    gtk_misc_set_alignment(GTK_MISC(image), 0.5, 0.5);
    gdk_pixbuf_loader_close(pbloader, NULL);
    g_free(buff);
    g_object_unref(pixbuff);
    g_free(undecoded);
    gtk_box_pack_start(GTK_BOX(hbox_edit), image, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_edit), vbox_left, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_edit), vbox_edit, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ui_data->box_profile), panarea, TRUE, TRUE, 0);
    gtk_widget_show_all(GTK_CONTAINER(ui_data->box_profile));
    xmlFreeDoc(request);
    return FALSE;
}

/**
 * @brief
 * @param
 * @return
**/
static gpointer ui_init_label(gchar* str_label)
{
    GtkWidget* label = gtk_label_new(NULL);
// !!!
    gchar* label_text = g_strconcat(MARKUP,str_label,": ",PUKRAM,NULL);
    gtk_label_set_markup(GTK_LABEL(label),label_text);    
    g_free(label_text);
    
    GtkWidget* alignment_label = gtk_alignment_new(1, 0.5, 0, 0);
    gtk_container_add(GTK_CONTAINER(alignment_label), label);
    gtk_widget_show_all(alignment_label);
    return alignment_label;
}

/**
 * @brief
 * @param
 * @return
**/
static gpointer ui_init_detail(gchar* str_label, gchar* str_value)
{
    GtkWidget* button = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    hildon_button_set_value(button, str_value);
    gtk_widget_set_name (GTK_WIDGET(button), str_label);
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(callback_detail_edit), (gpointer)str_value);
    return button;
}

/**
 * @brief create date chooser
 * @param str_label - name
 * @param str_value - current date value 
 * @return button
**/
static gpointer ui_init_date_chooser(gchar* str_label, gchar* str_value)
{
    gchar** numbers = g_strsplit(str_value, ".", 3);
    gint y = atoi(numbers[2]);
    gint m = atoi(numbers[1]) - 1;
    gint d = atoi(numbers[0]);
    g_strfreev(numbers);
    GtkWidget* button = hildon_date_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    hildon_date_button_set_date (button, y, m, d);
    hildon_button_set_title(button, NULL);
    hildon_button_set_value(button, str_value);
    g_signal_connect(G_OBJECT(button), "value-changed", G_CALLBACK(callback_date_edit), (gpointer)str_value);
    return button;
}

/**
 * @brief show list of friends
 * @param xmlDocPtr request - response from drivers
 */
gboolean ui_driver_get_friends(gpointer request)
{
    xmlXPathObject *Obj;
    xmlNodePtr node_root;
    xmlNodePtr node;
    gchar* str_name;
    gchar* str_status;
    gchar* str_filter;    
    gint i;
    int from = ui_data->page_frds * FRIENDS_PER_PAGE;
    int to = (ui_data->page_frds + 1) * FRIENDS_PER_PAGE;
    gboolean send = FALSE;
    GtkWidget* vbox_friends = gtk_vbox_new(FALSE, 0);
    GtkWidget* panarea = hildon_pannable_area_new();
    GtkWidget* friend;
    Friend* struct_friend;
    
    Obj = xpath(PARAMS_TAG_XPATH, request);
    node = Obj->nodesetval->nodeTab[0];
    g_hash_table_foreach_remove(ui_data->table_imgs, remove_friends_img, NULL);
    node_root = node->children;

    xmlChar* prop_value = xmlGetProp(node,"friendsQuantity");
    ui_data->num_frds = atoi((const char*)prop_value);
    xmlFree(prop_value);
    
    str_filter = xmlGetProp(node, "Filter");
    if (str_filter != NULL) {
        if (strlen(str_filter) > 0) {
            callback_friends_filter(str_filter);
        } else {
            callback_friends_filter(NULL);
        }
    } else {
        callback_friends_filter(NULL);
    }
    if (to >  ui_data->num_frds) {
        to =  ui_data->num_frds;
    }
    if (from == 0) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_prev), FALSE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_frst), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_prev), TRUE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_frst), TRUE);
    }
    if (to == ui_data->num_frds) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_next), FALSE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_last), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_next), TRUE);
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_friends_page_last), TRUE);
    }
    gtk_label_set_text(GTK_LABEL(ui_data->label_friends_page), g_strdup_printf("%d - %d / %d", from + 1, to, ui_data->num_frds));
    
    /* REMOVE FRIENDS LIST */
    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_friends_list));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }    
	hildon_pannable_area_add_with_viewport (panarea, vbox_friends);
    for (node = node_root; node != NULL; node = node->next) {
        struct_friend = struct_friend_create(1);
        struct_friend->str_id = xmlGetProp(node, "id");
        struct_friend->str_name = xmlNodeGetContent(node->children);
        struct_friend->str_status = xmlNodeGetContent(node->children->next);
        struct_friend->str_img = xmlNodeGetContent(node->children->next->next);
        struct_friend->str_uri = xmlGetProp(node->children->next->next, "uri");
        friend = ui_friend((gpointer)struct_friend);
        struct_friend_free(struct_friend);
        gtk_box_pack_start(GTK_BOX(vbox_friends), friend, FALSE, TRUE, 0);
    }
    gtk_box_pack_start(GTK_BOX (ui_data->box_friends_list), panarea, TRUE, TRUE, PADDING);
    gtk_widget_show_all(ui_data->box_friends_list);    
    xmlFreeDoc(request);
    return FALSE; 
}


gboolean remove_friends_img(gpointer key, gpointer value, gpointer user_data)
{
	g_free(key);
	gtk_widget_destroy(GTK_WIDGET(value));
	return TRUE;
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
gpointer ui_friend(gpointer ptr_friend)
{
    Friend* friend = ptr_friend;
    GSource* source;    
    GtkWidget* label_name = gtk_label_new(NULL);
    GtkWidget* hbox = gtk_hbox_new(FALSE, PADDING);
    GtkWidget* image;    
    GtkWidget* button_prf = hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL);
    GtkWidget* button_msg = hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL);
    GtkWidget* box_button_prf = gtk_hbox_new(FALSE, 0);        
    GtkWidget* box_button_msg = gtk_hbox_new(FALSE, 0);
    gchar* ptr_str_id;
    
    if (!strcmp(friend->str_status, "1")) {
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP_ONLINE, friend->str_name, PUKRAM, NULL));
    } else {
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP_OFFLINE, friend->str_name, PUKRAM, NULL));
    }
    gtk_misc_set_alignment(GTK_MISC(label_name), 0, 0.5);
    gtk_label_set_ellipsize(GTK_LABEL(label_name), PANGO_ELLIPSIZE_END);
    gtk_widget_set_name (GTK_WIDGET(label_name), friend->str_name);
    if (strlen(friend->str_img) > 0) { 
        int size;    
        guchar* buff = g_base64_decode(friend->str_img, &size);    
        GdkPixbufLoader* pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
        gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
	    GdkPixbuf* pixbuff_prev = gdk_pixbuf_loader_get_pixbuf(pbloader);
        int width = MIN_WIDTH_PHOTO;
        int height = gdk_pixbuf_get_height(pixbuff_prev) * MIN_WIDTH_PHOTO / gdk_pixbuf_get_width(pixbuff_prev);
        GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (pixbuff_prev, width, height, GDK_INTERP_BILINEAR);
        height = gdk_pixbuf_get_height(pixbuff);
        GdkPixbuf* pixbuffsquare = gdk_pixbuf_new(gdk_pixbuf_get_colorspace(pixbuff), FALSE, gdk_pixbuf_get_bits_per_sample(pixbuff), width, height);
        gdk_pixbuf_copy_area(pixbuff, 0, 0, gdk_pixbuf_get_width(pixbuff), height, pixbuffsquare, 0, 0);
        image = gtk_image_new_from_pixbuf(pixbuffsquare);    
        g_free(buff);
        g_object_unref(pixbuff);
        g_object_unref(pixbuff_prev);
        g_object_unref(pixbuffsquare);
	    gdk_pixbuf_loader_close(pbloader, NULL);
    } else {
        image = gtk_image_new_from_file(IMG_CONT);
        gpointer obj = (gpointer)image;
        gpointer key = (gpointer)g_strdup(friend->str_uri);
        g_hash_table_insert(ui_data->table_imgs, key, obj); 
        xmlDocPtr img_req = xmlParseDoc(img_resp);
        xmlXPathObject *Obj;
        Obj = xpath(REQUEST_PARAMS_TAG_XPATH, img_req);
        xmlNodePtr node_params = Obj->nodesetval->nodeTab[0];
        xmlNodePtr node_img;
        node_img = xmlNewNode(NULL, "img");
        xmlSetProp(node_img, "uri", friend->str_uri);
        xmlAddChild(node_params, node_img);
        kernel->send(img_req, NULL, NULL);
        //hildon_gtk_window_set_progress_indicator (ui_data->window, 1);
    }
    
    gtk_widget_set_usize(GTK_WIDGET(button_msg), MIN_WIDTH_CONTROL, NULL);
    gtk_widget_show_all(GTK_CONTAINER(ui_data->box_profile));
    gtk_button_set_relief(GTK_BUTTON(button_msg), GTK_RELIEF_NONE);
    gtk_container_add(GTK_CONTAINER(button_prf), box_button_prf);
    gtk_container_add(GTK_CONTAINER(button_msg), box_button_msg);
    gtk_box_pack_start(GTK_BOX (box_button_prf), image, FALSE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX (box_button_prf), label_name, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX (box_button_msg), gtk_image_new_from_file(IMG_COMP), TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), button_prf, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_button_prf), button_msg, FALSE, TRUE, 0);    
    ptr_str_id = g_strdup(friend->str_id);
    g_signal_connect(G_OBJECT(button_prf), "clicked", G_CALLBACK(callback_friend), (gpointer)ptr_str_id);
    g_signal_connect(G_OBJECT(button_msg), "clicked", G_CALLBACK(callback_friend_send_message), (gpointer)ptr_str_id);
    
    return hbox;
}

void ui_img_req(gpointer ptr_img_req)
{
    g_source_destroy(ui_data->source_time);
    g_source_unref(ui_data->source_time);
    kernel->send((xmlDocPtr)ptr_img_req, NULL, NULL);
}

/**
 * @brief
 * @param
 * @return
**/
gboolean ui_driver_get_friends_profile(gpointer request)
{
    xmlNodePtr node;
    xmlNodePtr cont;
    gchar* date_birth;

    g_source_destroy(ui_data->source_time);
    g_source_unref(ui_data->source_time);
   
    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params", request);
  
    node = obj->nodesetval->nodeTab[0]; 
    node = node->children;

    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_friends_profile));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_left = gtk_vbox_new(TRUE, 0);
    GtkWidget* vbox_right = gtk_vbox_new(TRUE, 0);
    GtkWidget* hbox_details = gtk_hbox_new(FALSE, 0);
    GtkWidget* panarea = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport (panarea, hbox_details);
    int i = 0;
    GtkWidget* detail;
    GtkWidget* label;
    
    while(node != NULL)
    {
        gchar* type = (gchar*)node->name;
        if (!strcmp(type, TYPE_STRNG)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            detail = gtk_label_new((gchar*)xmlNodeGetContent(node));
            GtkWidget* alignment_detail = gtk_alignment_new(0, 0.5, 0, 0);
            gtk_container_add(GTK_CONTAINER(alignment_detail), detail);
            gtk_box_pack_start (GTK_BOX (vbox_left), label, FALSE, FALSE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), alignment_detail, FALSE, FALSE, 0); 
        } else if (!strcmp(type, TYPE_DATE) && strcmp((gchar*)xmlNodeGetContent(node), "00.00.0")) {
            label = ui_init_label(xmlGetProp(node, "name"));
            detail = gtk_label_new((gchar*)xmlNodeGetContent(node));
            GtkWidget* alignment_detail = gtk_alignment_new(0, 0.5, 0, 0);
            gtk_container_add(GTK_CONTAINER(alignment_detail), detail);
            gtk_box_pack_start (GTK_BOX (vbox_left), label, FALSE, FALSE, 0);        
            gtk_box_pack_start (GTK_BOX (vbox_right), alignment_detail, FALSE, FALSE, 0);
        } else if (!strcmp(type, TYPE_IMAGE)) {
            cont = node;
        } else if (!strcmp(type, TYPE_SELCT)) {
            label = ui_init_label(xmlGetProp(node, "name"));
            gtk_box_pack_start (GTK_BOX (vbox_left), label, TRUE, TRUE, 0);  
            xmlNodePtr select = node->children;
            int i = 0;
            int n = 0;
            while (select != NULL) {
                if (!strcmp(xmlGetProp(select, "selected"), "1")) {
                    detail = gtk_label_new((gchar*)xmlNodeGetContent(select));
                    GtkWidget* alignment_detail = gtk_alignment_new(0, 0.5, 0, 0);
                    gtk_container_add(GTK_CONTAINER(alignment_detail), detail);
                    gtk_box_pack_start (GTK_BOX (vbox_right), alignment_detail, FALSE, FALSE, PADDING);
                }
                select = select->next;                
                i++;
            }            
        }
        node = node->next;
    }
    
    guchar* buff; 
    GdkPixbuf* pixbuff;  
    int size;    
    buff = g_base64_decode((gchar*)xmlNodeGetContent(cont), &size);    
    GdkPixbufLoader* pbloader;
    pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
    gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
    GdkPixbuf *pix_orig = gdk_pixbuf_loader_get_pixbuf(pbloader);
    gdk_pixbuf_loader_close (pbloader, NULL);
    
    int height = gdk_pixbuf_get_height(pix_orig);
    if (height > MAX_HEIGHT_PHOTO) {
        int width = gdk_pixbuf_get_width(pix_orig) * MAX_HEIGHT_PHOTO / height;
        height = MAX_HEIGHT_PHOTO;
        pixbuff = gdk_pixbuf_scale_simple (pix_orig, width, height, GDK_INTERP_BILINEAR);
        g_object_unref(pix_orig);
    } else {
        pixbuff = pix_orig;
    }        
    GtkWidget* image = gtk_image_new_from_pixbuf (pixbuff);
    g_object_unref(pixbuff);
    g_free(buff);

    
    gtk_box_pack_start(GTK_BOX(hbox_details), vbox_left, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_details), vbox_right, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_profile), image, FALSE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_profile), panarea, TRUE, TRUE, 0);
    gtk_widget_show_all(GTK_CONTAINER(ui_data->box_friends_profile));
    //resp = g_strdup("<answer>ok!</answer>");
    xmlXPathFreeObject(obj);
    xmlFreeDoc(request);
    return FALSE;
}

/**
 * @brief show list of messages
 * @param xmlDocPtr request - response from drivers
 */
gboolean ui_driver_get_messages(gpointer request)
{
    //g_source_destroy(ui_data->source_time); 
    //g_source_unref(ui_data->source_time);

    xmlXPathObject *Obj;
    xmlNodePtr node_root;
    xmlNodePtr node, child;
    gint i;
    gint from;
    gint to;
    Message* msg;
    
    Obj = xpath(RESPONSE_PARAMS_TAG_XPATH, request);
    node = Obj->nodesetval->nodeTab[0];

    char* prop_val = (char*)xmlGetProp(node, "messagesQuantity");
    ui_data->num_msgs = atoi(prop_val);
    free(prop_val);
    
    prop_val = xmlGetProp(node, "From");
    from = atoi(prop_val);
    free(prop_val);
    
    
    prop_val = xmlGetProp(node, "To");
    to = atoi(prop_val);
    free(prop_val);
    
    prop_val = NULL;
    
    if (to > ui_data->num_msgs) {
		to = ui_data->num_msgs;
    }

    if (from == 0) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_prev), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_prev), TRUE);
    }

    if (to == ui_data->num_msgs) {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_next), FALSE);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(ui_data->button_messages_page_next), TRUE);
    }
    
    Obj = xpath(PARAMS_TAG_XPATH, request);
  
    node = Obj->nodesetval->nodeTab[0];
    /* stuct contacts */
    node_root = node->children;
    
    /* REMOVE MESSAGES LIST */
    GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_messages_list));
    for (; children != NULL; children = children->next){
        gtk_widget_destroy(children->data); 
    }
    
    GtkWidget* vbox_messages = gtk_vbox_new(FALSE, 0);
    GtkWidget* panarea = hildon_pannable_area_new();
	hildon_pannable_area_add_with_viewport (panarea, vbox_messages);
    
    GtkWidget* message;
    GtkWidget* separator;
    gchar* xpath_req;
    //int n = 0;   
    
    for (node = node_root; node != NULL; node = node->next) {
        msg = g_new0(Message, 1);
        //xpath_req = g_strconcat(PARAMS_TAG_XPATH, "/struct[@='",xmlGetProp(node, "id"),"']",NULL);    
        //Obj = xpath(xpath_req, request);
        //child = Obj->nodesetval->nodeTab[0];
        for (child = node->children; child != NULL; child = child->next) {
            if (!strcmp(xmlGetProp(child, "name"), "SenderId"))
                msg->str_sender_id = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "SenderName"))
                msg->str_sender_name = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "RecipientId"))
                msg->str_recipient_id = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "RecipientName"))
                msg->str_recipient_name = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "Time"))
                msg->str_time = xmlNodeGetContent(child);
            if (!strcmp(xmlGetProp(child, "name"), "Text")) {
        	gchar *child_text = xmlNodeGetContent(child);
                msg->str_text = g_strcompress (child_text);
                g_free(child_text);
                child_text = msg->str_text;
                msg->str_text = g_markup_escape_text(child_text, strlen(child_text));
                g_free(child_text);
            }
            if (!strcmp(xmlGetProp(child, "name"), "Status"))
                msg->str_status = xmlNodeGetContent(child);
        }
        //if (n < 1) {
            message = ui_message((gpointer)msg);
            gtk_box_pack_start (GTK_BOX (vbox_messages), message, FALSE, TRUE, 0);
            //n++;
        //}
    }
    
    if (to > ui_data->num_msgs) {
        to = ui_data->num_msgs;
    }
    gtk_label_set_text(GTK_LABEL(ui_data->label_messages_page), g_strdup_printf("%d - %d", from + 1, to));
    gtk_box_pack_start (GTK_BOX (ui_data->box_messages_list), panarea, TRUE, TRUE, PADDING); 
    gtk_widget_show_all(ui_data->box_messages_list);
    
    // Kulakov: remove because valgrind says that it's already freed.
    //xmlXPathFreeObject(Obj);
    xmlFreeDoc(request);
    return FALSE; 
}

/**
 * @brief message
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
gpointer ui_message(gpointer msg_pointer)
{
    Message* msg = (Message*)msg_pointer;
    GtkWidget* container = hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL);
    mbox type;
    GtkWidget* label_name = gtk_label_new(NULL);
    if (strlen(msg->str_sender_name) > 0) {
        type = INBOX;
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP, STR_FROM, PUKRAM, msg->str_sender_name, NULL));
    } else  if (strlen(msg->str_recipient_name) > 0) {
        type = SENT;
        gtk_label_set_markup(GTK_LABEL(label_name), g_strconcat(MARKUP, STR_TO, PUKRAM, msg->str_recipient_name, NULL));
    }
    //GtkWidget* label_spac = gtk_label_new(" ");
    GtkWidget* label_time = gtk_label_new(NULL);
    
    gchar* str_date = malloc(sizeof(gchar) * 12);
    gchar* str_time = malloc(sizeof(gchar) * 8);
    long int time = atoi(msg->str_time);
	time += 60 * 60 * 4;
    struct tm* tm_time = gmtime(&time);
    strftime(str_date, 11, "%d.%m.%Y\0", tm_time);
    strftime(str_time, 7, "%H:%M\0", tm_time);
    msg->str_date = str_date;
// !!!    
    g_free(msg->str_time);    
    msg->str_time = str_time;
    gtk_label_set_markup(GTK_LABEL(label_time), g_strconcat(MARKUP, " ", str_date, "  ", str_time, PUKRAM, NULL));
    GtkWidget* label_text = gtk_label_new(NULL);
    
    if (!strcmp(msg->str_status, "0")){
        gtk_label_set_markup(GTK_LABEL(label_text), g_strconcat(MARKUP_UNREAD, msg->str_text, PUKRAM, NULL));
    } else {
        gtk_label_set_markup(GTK_LABEL(label_text), g_strconcat(MARKUP_READ, msg->str_text, PUKRAM, NULL));   
    }
    gtk_label_set_line_wrap(GTK_LABEL(label_text), TRUE);
    gtk_label_set_single_line_mode(GTK_LABEL(label_text), FALSE);
    gtk_label_set_ellipsize(GTK_LABEL(label_text), PANGO_ELLIPSIZE_END);
    GtkWidget* hbox_from = gtk_hbox_new(FALSE, 0);
    GtkWidget* hbox_text = gtk_hbox_new(FALSE, 0);
    GtkWidget* vbox = gtk_vbox_new(FALSE, 0);
    gtk_misc_set_alignment(GTK_MISC(label_text), 0, 0.5);
    gtk_misc_set_alignment(GTK_MISC(label_name), 0, 0.5);
    gtk_misc_set_alignment(GTK_MISC(label_time), 1, 0.5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox_from, FALSE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox_text, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_from), label_name, TRUE, TRUE, 0);
    //gtk_box_pack_start(GTK_BOX(hbox_from), label_spac, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_from), label_time, TRUE, TRUE, 0);
    
    //label_spac = gtk_label_new(" ");
    gtk_box_pack_start(GTK_BOX(hbox_text), label_text, TRUE, TRUE, 0);
    
    gtk_container_add(GTK_CONTAINER(container), vbox);
    
    if (type == INBOX) {
        g_signal_connect(G_OBJECT(container), "clicked", G_CALLBACK(callback_message_reply), (gpointer)msg);
    } else {
        g_signal_connect(G_OBJECT(container), "clicked", G_CALLBACK(callback_empty), msg_pointer);
    }
    gtk_widget_show_all(container);
    return container;
}

/**
 * @brief generate xpath request to xmlDocPtr 
 * @param req - xpath req
 * @param doc - xmlDocPtr  
 * @return xmlXPathObject*  
**/
xmlXPathObject* xpath(char* req, xmlDocPtr doc)
{
    xmlXPathObject *Obj;
    xmlXPathContextPtr Ctx;
    
    g_debug("ui_xpath: %s", req);

    Ctx = xmlXPathNewContext(doc);
    
    if (Ctx == NULL) {
        g_debug("ui_xpath: error wrong request format!");
        return NULL;    
    }

    Obj = xmlXPathEvalExpression(req, Ctx);

    xmlXPathFreeContext(Ctx);

    g_debug("ui_xpath: end");

    return Obj;
}

/**
 * @brief search name_node in node 
 * @param node - where to search
 * @param name_node - what to search  
 * @return xmlNodePtr*  
**/
xmlNodePtr node_search(xmlNodePtr node, char* name_node)
{
    //g_debug("i'm in %s %s", node->name, name_node);
    
    node = node->children;
    
    while(node != NULL){
        if(strcmp(node->name, name_node) == 0){
                    break;
        }
    //g_debug("%s %s", node->name, name_node);
        node = node->next;
    }
    return node;
}

/**
 * @brief get class name and function name from response
 * @param reqXml - where to search
 * @param class_name - where to put class name 
 * @param class_name - where to put function name 
 * @return 1 if error occurred, 0 if no errors occurred
**/
int get_function_from_response(xmlDocPtr reqXml, char** class_name, char** func)
{
    g_debug("get_function_from_response: START");

    xmlNodePtr rootNode;

    //g_debug("get_req_class: START");

    rootNode = xmlDocGetRootElement(reqXml);
    
    //g_debug("get_req_class: %s", rootNode->name);        
    rootNode = node_search(rootNode, "Content");
    
    // Request
    //g_debug("get_req_class: %s", rootNode->name);
    
    if(node_search(rootNode, "Response") != NULL) {
        rootNode = node_search(rootNode, "Response");
    } else {
        rootNode = node_search(rootNode, "Request");
        if (rootNode == NULL) {
            //g_debug("get_req_class: END no func and class");
            return 1;
        }
    }
    //g_debug("get_req_class: %s", rootNode->name);

    //xmlDocDump(stdout, reqXml);
    *class_name = xmlGetProp(rootNode,"class");
    *func = xmlGetProp(rootNode,"function");
    
    
    g_debug("get_function_from_response: START");
    g_debug("get_req_class: END class = %s, func = %s", *class_name, *func);
    
    return 0;
}

/**
 * @brief get driver settings
 * @param reqXml - response from driver
**/
gboolean ui_driver_get_settings(gpointer ptr_reqXml)
{
    //g_source_destroy(ui_data->source_time);
    //g_source_unref(ui_data->source_time);

    xmlNodePtr rootNode;
    xmlNodePtr node;
    char* driver_id;
    GtkWidget* entries[4];
    int i = 0;
    
    g_print("\tui_driver_get_settings: START");
    
    rootNode = xmlDocGetRootElement(ptr_reqXml);
    //g_debug("ui_driver_get_settings: START");
    
    // Получаем имя источника
    node = node_search(rootNode, "SourceID");
    driver_id = xmlNodeGetContent(node);
 
    //g_debug("ui_dirver_get_settings: %s", driver_id);
    
    rootNode = node_search(rootNode, "Content");
    
    // Resopnse
    rootNode = node_search(rootNode, "Response");
    rootNode = rootNode->children;
    gchar* string;
    
    for(node = rootNode->children; node != NULL; node = node->next) { 
        string = xmlGetProp(node, "name");
        if (!strcmp(string, "login")){
	    g_free(string);
	    string = xmlNodeGetContent(node);
            gtk_entry_set_text(GTK_ENTRY(ui_data->entry_logn), string);
        } else if (!strcmp(string, "password")){
	    g_free(string);
	    string = xmlNodeGetContent(node);
            gtk_entry_set_text(GTK_ENTRY(ui_data->entry_pass), string);
        } else if (!strcmp(string, "autoupdate")){
  	    g_free(string);
	    string = xmlNodeGetContent(node);
            hildon_number_editor_set_value(ui_data->entry_auto, atoi(string));
        }
        //string = xmlNodeGetContent(node);
	g_free(string);
    }
    gtk_widget_show_all(ui_data->box_setting);
    callback_driver_settings(NULL);
    xmlFreeDoc((xmlDocPtr)ptr_reqXml);

    return FALSE;
}

/**
 * @brief show info from xml
 * @param
 * @return
**/
gboolean ui_show_info(gpointer request)
{
    //g_source_destroy(ui_data->source_time);
    //g_source_unref(ui_data->source_time);

    gchar* text;
    gchar* code;
    gchar* id_friend;
    gboolean show = TRUE;

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/string[@name='text']", request);
     
    if (obj->nodesetval->nodeNr != 0) {
        text = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
        id_friend = text;
    }

    xmlXPathFreeObject(obj);

    //g_debug("send request :getProfile:");
    obj = xpath("//TransitData/Content/Response/Params/string[@name='code']", request);
     
    if (obj->nodesetval->nodeNr != 0) {
        code = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    xmlXPathFreeObject(obj);
    
    g_print("\n###########\n#         #\n#   %s   #\n#         #\n###########\n", code);
    
    if (strcmp(code, "400") == 0) {
        callback_button_profile_update(NULL, NULL);
    }
    
    if (strcmp(code, DB_SAVE_MESSAGE_PROFILE_CODE) == 0) {
        callback_button_profile_get(NULL, NULL);
    }
    
    if (strcmp(code, DB_SAVE_MESSAGE_FRIENDS_CODE) == 0) {
        callback_button_friends_get(NULL, NULL);   
    }

    if (strcmp(code, DB_UPDATE_MESSAGE_INBOX_MESSAGES_CODE) == 0 || strcmp(code, DB_NEW_INBOX_MESSAGES_CODE) == 0) {
        callback_button_messages_get(NULL, NULL);   
    }
    
    if (strcmp(code, DB_UPDATE_MESSAGE_OUTBOX_MESSAGES_CODE) == 0) {
        callback_button_messages_get(NULL, NULL);   
    }
    
    if (strcmp(code, DRV_SETT_SAVED_CODE) == 0) {
        callback_button_profile_update(NULL, NULL);   
    }


    if (strcmp(code, DB_SAVE_MESSAGE_FRIENDS_PROFILE_CODE) == 0) {
        show = FALSE;
        callback_button_friend_get(NULL, (gpointer)id_friend);
    }

    if (strcmp(code, DB_GET_ERROR_INBOX_MESSAGES_CODE) == 0 || strcmp(code, DB_GET_ERROR_OUTBOX_MESSAGES_CODE) == 0) {
        GList* children = gtk_container_get_children (GTK_CONTAINER(ui_data->box_messages_list));
        for (; children != NULL; children = children->next){
            gtk_widget_destroy(children->data); 
        }
        gtk_label_set_text(GTK_LABEL(ui_data->label_messages_page), STR_EMPT);
    }
    
    if (show) {
        hildon_banner_show_information(ui_data->window, NULL, text);
    } else {
        hildon_banner_show_information(ui_data->window, NULL, DB_SAVE_MESSAGE_FRIENDS_PROFILE_TEXT);
    }
    //hildon_gtk_window_set_progress_indicator (ui_data->window, 0);
    g_free(code);
    xmlFreeDoc(request);
    return FALSE;    
}

/**
 * @brief show error from xml
 * @param
 * @return
**/
gboolean ui_show_error(gpointer request)
{
    g_source_destroy(ui_data->source_time);
    g_source_unref(ui_data->source_time);
    gboolean show = TRUE;
    gchar* text;
    gchar* code;

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/string[@name='text']", request);
     
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        text = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    else {
        return FALSE;
    }
    obj = xpath("//TransitData/Content/Response/Params/string[@name='code']", request);
    if (obj->nodesetval->nodeNr != 0) {
        code = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    
    g_print("\n##################\n#                #\n#   ERROR: %s   #\n#                #\n##################\n", code);
    
    if(strcmp(code, DB_GET_ERROR_FRIENDS_CODE) == 0) {
        show = FALSE;
        gtk_label_set_text(GTK_LABEL(ui_data->label_friends_page), STR_EMPT);
        callback_button_friends_update(NULL, NULL);
    }
    if(strcmp(code, DB_GET_ERROR_PROFILE_CODE) == 0){
        show = FALSE;
        callback_button_profile_update(NULL, NULL);
    }
    if(strcmp(code, DB_GET_ERROR_INBOX_MESSAGES_CODE) == 0 || strcmp(code, DB_GET_ERROR_OUTBOX_MESSAGES_CODE) == 0){
        show = FALSE;
        callback_button_messages_update(NULL, NULL);
    }
    if(strcmp(code, DB_SAVE_ERROR_FRIENDS_PROFILE_CODE) == 0){
        show = FALSE;
        g_signal_emit_by_name(ui_data->button_friend_profile_refresh, "clicked");
    }
    if(strcmp(code, DB_GET_ERROR_BINARY_CODE) == 0){
        show = FALSE;
    }
    if(show)
        hildon_banner_show_information(ui_data->window, NULL, text);
    //hildon_gtk_window_set_progress_indicator (ui_data->window, 0);
    xmlXPathFreeObject(obj);
    xmlFreeDoc(request);

    return FALSE;
}

/**
 * @brief show captcha
 * @param
 * @return
**/
gboolean ui_show_captcha(gpointer request)
{
    //g_source_destroy(ui_data->source_time);
    //g_source_unref(ui_data->source_time);

    xmlNodePtr node;
    gchar* str;
    gchar* str_img;
    GtkWidget* image;
    int size;
    int width;
    int height;
    gchar* str_entry;
    xmlDocPtr req_drv;

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/string[@name='text']", request);
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        str = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
    }
    else {
        return 1;
    }
    
    obj = xpath("//TransitData/Content/Response/Params/img", request);
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        str_img = xmlNodeGetContent(obj->nodesetval->nodeTab[0]);
        g_print("%s\n\n", str_img);
	gchar* buff;
        buff = g_base64_decode(str_img, &size);    
	GdkPixbufLoader* pbloader;
	GdkPixbuf* pixbuff;
        
        pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
        gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
        GdkPixbuf *pix_orig = gdk_pixbuf_loader_get_pixbuf(pbloader);
        gdk_pixbuf_loader_close (pbloader, NULL);
        
        width = MIN_WIDTH;
        height = gdk_pixbuf_get_height(pix_orig) * MIN_WIDTH / gdk_pixbuf_get_width(pix_orig);
        pixbuff = gdk_pixbuf_scale_simple (pix_orig, width, height, GDK_INTERP_BILINEAR);
        image = gtk_image_new_from_pixbuf(pixbuff);
        
        g_object_unref(pixbuff);
        g_object_unref(pix_orig);
    }
    else {
        return FALSE;
    }
    
    GtkWindow* window;
    GtkDialog* dialog;

    GtkWidget* vbox = gtk_vbox_new( FALSE, 0 ); 
    GtkWidget* label;
    GtkWidget* button;
    GtkWidget* entry;

    int result;      

    dialog = GTK_DIALOG(gtk_dialog_new());
    if(!dialog) {
        return FALSE;
    }

    gtk_window_set_title(GTK_WINDOW(dialog), str);
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    /* buttons */        
    button = gtk_button_new_with_label(STR_CNCL);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_CANCEL);    
    button = gtk_button_new_with_label(STR_OK__);
    gtk_dialog_add_action_widget( dialog, button, GTK_RESPONSE_ACCEPT);

    entry = gtk_entry_new();
    gtk_widget_set_usize (entry, -1, MIN_HEIGHT);
    gtk_container_add(GTK_CONTAINER(dialog->vbox), image);
    gtk_container_add(GTK_CONTAINER(dialog->vbox), entry);
    gtk_widget_show_all( GTK_WIDGET( dialog ) );
    result = gtk_dialog_run(dialog);
    if( result == GTK_RESPONSE_ACCEPT) {
        str_entry = gtk_entry_get_text(GTK_ENTRY(entry));

        req_drv = xmlCopyDoc(request, 1);
        /* change name node, class, function */
        obj = xpath("//TransitData/Content/Response", req_drv);
        if (obj->nodesetval->nodeNr != 0) {
            node = obj->nodesetval->nodeTab[0];
            xmlNodeSetName(node, "Request");
        }    
        /* change source id */
        obj = xpath(SOURCE_TAG_XPATH, req_drv);
        if (obj->nodesetval->nodeNr != 0) {
            node = obj->nodesetval->nodeTab[0];
            xmlNodeSetContent(node, "db");
        }    
        /** create target id **/
        obj = xpath(TARGET_TAG_XPATH, req_drv);
        if (obj->nodesetval->nodeNr != 0) {
            node = obj->nodesetval->nodeTab[0];
            xmlNodeSetContent(node, "vkontakte");
        }
        else {
            //FIXME
            node = xmlNewDocNode(req_drv, NULL, TARGET_NODE, "vkontakte");
            xmlNodePtr root = xmlDocGetRootElement(req_drv);
            xmlAddChild(root, node);    
        }
        obj = xpath("//TransitData/Content/Request/Params/string[@name='text']", req_drv);
        if (obj != NULL && obj->nodesetval->nodeNr != 0) {
            xmlNodeSetContent(obj->nodesetval->nodeTab[0],str_entry);
        }
        else {
            return FALSE;
        }
        //xmlDocDump(stdout,req_drv);
          kernel->send(req_drv, NULL, NULL);       
    }    
    gtk_widget_destroy(GTK_WIDGET(dialog));
    xmlXPathFreeObject(obj);
    xmlFreeDoc(request);
    return FALSE;
}

/**
 * @brief show img from xml
 * @param
 * @return
**/
gboolean ui_show_img(gpointer request)
{
    //g_source_destroy(ui_data->source_time);
    //g_source_unref(ui_data->source_time);

    xmlXPathObject* obj = xpath("//TransitData/Content/Response/Params/img", request);
    xmlNodePtr node_bin;
    xmlNodePtr node;

    gchar* s_uri;
    gchar* s_img;  
    int size;    
    int height;
    int width = MIN_WIDTH_PHOTO;
    guchar* buff;
    
    if (obj != NULL && obj->nodesetval->nodeNr != 0) {
        node = obj->nodesetval->nodeTab[0];
    }
    else {
        return 1;
    }

    for (node_bin = node; node_bin != NULL; node_bin = node_bin->next) {
    
        s_uri = xmlGetProp(node_bin, "uri");
        s_img = xmlNodeGetContent(node_bin);

        buff = g_base64_decode(s_img, &size);    
        GdkPixbufLoader* pbloader;
        pbloader = gdk_pixbuf_loader_new_with_type ("jpeg", NULL);
        gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
        gdk_pixbuf_loader_close (pbloader, NULL);
        width = MIN_WIDTH_PHOTO;
        height = gdk_pixbuf_get_height(gdk_pixbuf_loader_get_pixbuf(pbloader)) * MIN_WIDTH_PHOTO / gdk_pixbuf_get_width(gdk_pixbuf_loader_get_pixbuf(pbloader));
        GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (gdk_pixbuf_loader_get_pixbuf(pbloader), width, height, GDK_INTERP_BILINEAR);
        height = gdk_pixbuf_get_height(pixbuff);
        if (gdk_pixbuf_get_height(pixbuff) > gdk_pixbuf_get_width(pixbuff)) {
            height = gdk_pixbuf_get_width(pixbuff);
        }
        GdkPixbuf* pixbuffsquare = gdk_pixbuf_new(gdk_pixbuf_get_colorspace(pixbuff), FALSE, gdk_pixbuf_get_bits_per_sample(pixbuff), gdk_pixbuf_get_width(pixbuff), height);
        gdk_pixbuf_copy_area(pixbuff, 0, 0, gdk_pixbuf_get_width(pixbuff), height, pixbuffsquare, 0, 0);
        gpointer value = g_hash_table_lookup(ui_data->table_imgs, (gpointer)s_uri);
        //g_print("\n\n\n!!! S_URI: %s !!!\n\n\n!!! WIDGET IS: %s !!!\n\n\n", s_uri, gtk_widget_get_name(GTK_WIDGET(value)));
        gtk_image_set_from_pixbuf ((GtkImage*)value, pixbuffsquare);
        //g_free(buff);
        //g_object_unref(pixbuff);
        //g_object_unref(pixbuffsquare);
        //g_free(pbloader);
        //g_object_unref(pbloader); 
    }
    xmlXPathFreeObject(obj);
    xmlFreeDoc(request);
    return FALSE;
}

Friend *struct_friend_create()
{
    Friend *ret = g_malloc(sizeof(Friend));
    ret->str_name = NULL;
    ret->str_id = NULL;
    ret->str_status = NULL;
    ret->str_img = NULL;
    ret->str_uri = NULL;
    return ret;
}

void struct_friend_free(Friend *fr)
{
    if (fr->str_name != NULL)
	g_free(fr->str_name);
    if (fr->str_id != NULL)
	g_free(fr->str_id);
    if (fr->str_status != NULL)
	g_free(fr->str_status);
    if (fr->str_img != NULL)
	g_free(fr->str_img);
    if (fr->str_uri != NULL)
	g_free(fr->str_uri);
    g_free(fr);
}
