/*
 * db_msa_logic.h - interface fo msa db logic.
 * This file is part of DB-Maemo.
 *
 * Copyright (C) 2009 - Ilia L. Burlak
 *
 * DB-Maemo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DB-Maemo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DB-Maemo; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
#ifndef _DB_INTERFACE_FUNCTION_H_
#define _DB_INTERFACE_FUNCTION_H_

#include "db.h"
#include "db_msa_logic.h"

#define DB_SEND_REQUEST db_send_request

#define DB_SAVE_PROFILE db_save_profile
#define DB_GET_PROFILE db_get_profile_ui
#define GET_NEW_MESSAGES_FUNC db_new_message_func

#define DB_SAVE_FRIENDS db_friends_save
#define DB_GET_FRIENDS db_friends_get

#define DB_SAVE_INBOX_MESSAGES db_save_inbox_message
#define DB_GET_INBOX_MESSAGES db_get_inbox_mess

#define DB_SAVE_BINARY_DATA db_save_binary_data

typedef enum _db_type 
{
	TYPE_REQUEST,
	TYPE_RESPONSE
} db_type;

xmlDocPtr DB_SEND_REQUEST(xmlDocPtr ui_request);

xmlDocPtr DB_SAVE_PROFILE(xmlDocPtr drv_response);
xmlDocPtr DB_GET_PROFILE(xmlDocPtr ui_request);

xmlDocPtr DB_SAVE_FRIENDS(xmlDocPtr drv_response);
xmlDocPtr DB_GET_FRIENDS(xmlDocPtr request);

xmlDocPtr DB_SAVE_BINARY_DATA(xmlDocPtr drv_response); 

xmlDocPtr DB_SAVE_INBOX_MESSAGES(xmlDocPtr drv_response);
xmlDocPtr DB_GET_INBOX_MESSAGES(xmlDocPtr ui_request);

xmlDocPtr GET_NEW_MESSAGES_FUNC(xmlDocPtr drv_response);

#endif
