
/*
 * converter.h - interface for converter.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov. All rights reserved.
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#ifndef _CONVERTER_H
#define	_CONVERTER_H

#ifdef	__cplusplus
extern "C" {
#endif

//#include "driver.h"
#include <libxslt/xslt.h>
#include <libxslt/transform.h>
#include <glib.h>
#include "jabber_general.h"

xmlDocPtr convert_inner_profile_to_jabber_format(const xmlDocPtr profile);

xmlDocPtr convert_jabber_profile_to_inner_format(const xmlDocPtr jb_profile,
        const gchar* own_id, const gchar* driver_prefix, const gchar* func_name);

xmlDocPtr convert_jabber_roster_to_inner_format(const xmlDocPtr jb_roster,
        const gchar* own_id, const gchar* driver_prefix, const gchar* func_name);

xmlDocPtr convert_inner_message_to_jabber_format(const xmlDocPtr message,
        const gchar* own_id, const gchar* driver_prefix);

#ifdef	__cplusplus
}
#endif

//#define PROGRAM_NAME "msa"

//#ifdef DATADIR
//#define DRIVER_DATADIR DATADIR"/"PROGRAM_NAME"/"DRIVER_ID"/data/"
//#else
//#define DRIVER_DATADIR "./data/"
//#endif


#endif	/* _CONVERTER_H */

