<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:bio="http://purl.org/vocab/bio/0.1/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact"
    xmlns:ad="http://schemas.talis.com/2005/address/schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
           
    version="1.0">

	<xsl:param name="ID"></xsl:param>

	
<!--	exclude-result-prefixe="rdf sonet foaf bio xsl contact ad dc"
    extension-element-prefixes="rdf sonet foaf bio xsl contact ad dc" 
-->


    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>

	<xsl:template match="Params">

		 <rdf:RDF
			xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
			xmlns:rel="http://purl.org/vocab/relationship/"
			xmlns:foaf="http://xmlns.com/foaf/0.1/">


			<foaf:Person>

				<xsl:attribute name="rdf:ID">
					<xsl:value-of select="$ID" />
				</xsl:attribute>
		
					<foaf:firstName>
						<xsl:value-of select="string[@name='FirstName']" />			
					</foaf:firstName>					
				
					<foaf:surname>
						<xsl:value-of select="string[@name='LastName']" />			
					</foaf:surname>

					<sonet:img>
						<xsl:attribute name="sonet:BinaryID">
							<xsl:value-of select="img[@name='Img']/@uri"/>
						</xsl:attribute>			
						<xsl:value-of select="img[@name='Img']" />
					</sonet:img>

					<sonet:City>
						<sonet:CityId>
							<xsl:value-of select="struct[@name='City']/string[@name='CityId']"/>
						</sonet:CityId>
						<sonet:CityName>
							<xsl:value-of select="struct[@name='City']/string[@name='CityName']"/>
						</sonet:CityName>					
					</sonet:City>

					<sonet:Country>
						<sonet:CountryId>
							<xsl:value-of select="struct[@name='Country']/string[@name='CountryId']"/>
						</sonet:CountryId>
						<sonet:CountryName>
							<xsl:value-of select="struct[@name='Country']/string[@name='CountryName']"/>
						</sonet:CountryName>					
					</sonet:Country>

					<bio:date>
						<xsl:value-of select="date[@name='Birthday']"/>			
					</bio:date>

					<foaf:gender>
						<xsl:value-of select="select[@name='Gender']/string[@selected='1']"/>			
					</foaf:gender>

					<sonet:genderSelect>

						<xsl:for-each select="select[@name='Gender']/string">					
							<sonet:string>
								<xsl:attribute name="selected">
									<xsl:value-of select="./@selected"/>
								</xsl:attribute>
								<xsl:value-of select="."/>
							</sonet:string>
						</xsl:for-each>

					</sonet:genderSelect>

					<sonet:familyState>
						<xsl:value-of select="select[@name='FamilyState']/string[@selected='1']"/>			
					</sonet:familyState>

					<sonet:familyStateSelect>

						<xsl:for-each select="select[@name='FamilyState']/string">					
							<sonet:string>
								<xsl:attribute name="selected">
									<xsl:value-of select="./@selected"/>
								</xsl:attribute>
								<xsl:value-of select="."/>
							</sonet:string>
						</xsl:for-each>

					</sonet:familyStateSelect>

					<sonet:politicalView>
						<xsl:value-of select="select[@name='PoliticalView']/string[@selected='1']"/>			
					</sonet:politicalView>

					<sonet:politicalViewSelect>

						<xsl:for-each select="select[@name='PoliticalView']/string">					
							<sonet:string>
								<xsl:attribute name="selected">
									<xsl:value-of select="./@selected"/>
								</xsl:attribute>
								<xsl:value-of select="."/>
							</sonet:string>
						</xsl:for-each>

					</sonet:politicalViewSelect>

					<sonet:educationList>

						<xsl:for-each select="array[@name='EducationList']">					
							<sonet:Education>
								<sonet:educationType>
									<xsl:value-of select="./struct/string[@name='Type']"/>		
								</sonet:educationType>
								<sonet:educationName>
									<xsl:value-of select="./struct/string[@name='Name']"/>		
								</sonet:educationName>
								<sonet:educationDateComplete>
									<xsl:value-of select="./struct/string[@name='DateComplete']"/>		
								</sonet:educationDateComplete>							
							</sonet:Education>

						</xsl:for-each>

					</sonet:educationList>

					
					



			</foaf:Person>

		</rdf:RDF>

	</xsl:template>

	
</xsl:stylesheet>

