<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:bio="http://purl.org/vocab/bio/0.1/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact"
    xmlns:ad="http://schemas.talis.com/2005/address/schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
           
    version="1.0">

	<xsl:param name="ID"></xsl:param>

	
<!--	exclude-result-prefixe="rdf sonet foaf bio xsl contact ad dc"
    extension-element-prefixes="rdf sonet foaf bio xsl contact ad dc" 
-->


    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>

	<xsl:template match="struct">

		 <rdf:RDF
			xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
			xmlns:rel="http://purl.org/vocab/relationship/"
			xmlns:foaf="http://xmlns.com/foaf/0.1/">

			<sonet:Contact>
			
				<xsl:attribute name="rdf:ID">
					<xsl:value-of select="$ID" />
				</xsl:attribute>
				
				<foaf:firstName>
						<xsl:value-of select="string[@name='FriendName']"/>			
				</foaf:firstName>

				<foaf:firstStatus>
						<xsl:value-of select="string[@name='FriendStatus']"/>			
				</foaf:firstStatus>

				<sonet:img>
					<xsl:attribute name="sonet:BinaryID">
						<xsl:value-of select="img[@name='FriendImg']/@uri"/>
					</xsl:attribute>			
				</sonet:img>


			</sonet:Contact>

		</rdf:RDF>
		

	</xsl:template>

	
</xsl:stylesheet>
