#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"
#include <kernel/general.h>
#include <kernel/repository.h>
#include <msa_module.h>
#include <gconf/gconf-client.h>
#include <glib.h>
GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;


CTF_TEST_CASE(repository_add_data_test) {

    CTF_TEST_NAME("repository_add_data_test");

    xmlDocPtr reqXml;
    int repository_length = 0;

    repository_add_data(NULL);
    repository_add_data(NULL);
    repository_add_data(NULL);    
   
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);


    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  
}



CTF_TEST_CASE(repository_get_newest_transit_data_test) {

    
    CTF_TEST_NAME("repository_add_data_test");

    xmlDocPtr reqXml;
    int repository_length = 0;

    transit_data* tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("1");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("2");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("3");
    
    repository_add_data(tr_data);    
   
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);

    CTF_TEST_NAME("repository_get_newest_transit_data_test");

    transit_data* check_tr_data = repository_get_newest_transit_data(FALSE);

    CTF_CHECK(!strcmp(check_tr_data->id, "3"));

    CTF_CHECK(repository_length == 3);


    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  

    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("1");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("2");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("3");
    
    repository_add_data(tr_data);    
   
    CTF_TEST_NAME("repository_get_lenght_test");
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);

    CTF_TEST_NAME("repository_get_newest_transit_data_test");
    check_tr_data = repository_get_newest_transit_data(TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "3"));

    check_tr_data = repository_get_newest_transit_data(TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "2"));

    check_tr_data = repository_get_newest_transit_data(TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "1"));

    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);

  
    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  
  
}


CTF_TEST_CASE(repository_get_oldest_transit_data_test) {

    
    CTF_TEST_NAME("repository_add_data_test");

    xmlDocPtr reqXml;
    int repository_length = 0;

    transit_data* tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("1");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("2");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("3");
    
    repository_add_data(tr_data);    
   
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);

    CTF_TEST_NAME("repository_get_oldest_transit_data_test");

    transit_data* check_tr_data = repository_get_oldest_transit_data(FALSE);
    CTF_CHECK(!strcmp(check_tr_data->id, "1"));

    check_tr_data = repository_get_oldest_transit_data(FALSE);
    CTF_CHECK(!strcmp(check_tr_data->id, "1"));

    CTF_CHECK(repository_length == 3);


    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  

    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("1");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("2");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("3");
    
    repository_add_data(tr_data);    
   
    CTF_TEST_NAME("repository_get_lenght_test");
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);

    CTF_TEST_NAME("repository_get_oldest_transit_data_test");
    check_tr_data = repository_get_oldest_transit_data(TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "1"));

    check_tr_data = repository_get_oldest_transit_data(TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "2"));

    check_tr_data = repository_get_oldest_transit_data(TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "3"));

    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);

  
    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  
  
}


CTF_TEST_CASE(repository_get_transit_data_by_index_test) {

    
    CTF_TEST_NAME("repository_add_data_test");

    xmlDocPtr reqXml;
    int repository_length = 0;

    transit_data* tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("1");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("2");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("3");
    
    repository_add_data(tr_data);    
   
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);

    CTF_TEST_NAME("repository_get_transit_data_by_index_test");

    transit_data* check_tr_data = repository_get_transit_data_by_index(1, FALSE);
    CTF_CHECK(!strcmp(check_tr_data->id, "2"));

    check_tr_data = repository_get_transit_data_by_index(0, FALSE);
    CTF_CHECK(!strcmp(check_tr_data->id, "1"));

    check_tr_data = repository_get_transit_data_by_index(2, FALSE);
    CTF_CHECK(!strcmp(check_tr_data->id, "3"));

    check_tr_data = repository_get_transit_data_by_index(-1, FALSE);
    CTF_CHECK((check_tr_data == NULL));

    check_tr_data = repository_get_transit_data_by_index(10, FALSE);
    CTF_CHECK((check_tr_data == NULL));

    CTF_CHECK(repository_length == 3);


    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  

    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("1");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("2");
    
    repository_add_data(tr_data);
    
    tr_data = g_new(transit_data, 1);
    tr_data->id = g_strdup("3");
    
    repository_add_data(tr_data);    
   
    CTF_TEST_NAME("repository_get_lenght_test");
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 3);

    CTF_TEST_NAME("repository_get_transit_data_by_index_test");

    check_tr_data = repository_get_transit_data_by_index(1,TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "2"));

    check_tr_data = repository_get_transit_data_by_index(1,TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "3"));

    check_tr_data = repository_get_transit_data_by_index(0,TRUE);
    CTF_CHECK(!strcmp(check_tr_data->id, "1"));

    check_tr_data = repository_get_transit_data_by_index(1,TRUE);
    CTF_CHECK((check_tr_data == NULL));

    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  
    CTF_TEST_NAME("repository_free_test");
    repository_free();
    
    repository_length = repository_get_length();
    CTF_CHECK(repository_length == 0);
  
  
}


