#ifdef ENABLE_NOTIFY
#include <libnotify/notify.h>
#endif

#include "mainwindow.h"

#include <QLibraryInfo>
#include <QtGui/QApplication>
#include <QObject>
#include <QTranslator>

int main(int argc, char *argv[])
{
    // register required types for inter-thread communications
    QApplication a(argc, argv);
    a.setApplicationName(APP_NAME);
    a.setOrganizationName("PetrSU");
    a.setOrganizationDomain("cs.karelia.ru");

    QString locale = QLocale::system().name();
    QTranslator translator;
    translator.load(QString(APP_NAME) + "_" + locale,
        DATAPREFIX"/qt4/translations/");
    a.installTranslator(&translator);

    QTranslator commontr;
    commontr.load(QString("mysocials_core") + "_" + locale,
        DATAPREFIX"/qt4/translations");
    a.installTranslator(&commontr);

    QTranslator qtTranslator;
    qtTranslator.load("qt_" + QLocale::system().name(),
                      QLibraryInfo::location(QLibraryInfo::TranslationsPath));
    a.installTranslator(&qtTranslator);

    Q_INIT_RESOURCE(mysocials_res);

#ifdef ENABLE_NOTIFY
    // init libnotify library
    notify_init(APP_NAME);
#endif

    MainWindow w;
    w.showMaximized();
    return a.exec();
}
