#include <libnotify/notify.h>

#include "ui/vkgallery.h"

#include <QApplication>
#include <QObject>
#include <QTranslator>
#include <QLibraryInfo>

int main(int argc, char *argv[])
{
    // register required types for inter-thread communications
    QApplication a(argc, argv);
    a.setApplicationName(APP_NAME);
    a.setOrganizationName("PetrSU");
    a.setOrganizationDomain("cs.karelia.ru");

    QString locale = QLocale::system().name();
    QTranslator translator;
    translator.load(QString(APP_NAME) + "_" + locale,
	DATAPREFIX"/qt4/translations/");
    a.installTranslator(&translator);

    QTranslator commontr;
    commontr.load(QString("mysocials_core") + "_" + locale,
	DATAPREFIX"/qt4/translations/");
    a.installTranslator(&commontr);

    /* Init libnotify library */
    notify_init(APP_NAME);

    VKGallery w;
    w.showMaximized();
    return a.exec();
}
