#include "vkgallery.h"
#include "ui_vkgallery.h"

VKGallery::VKGallery(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::VKGallery)
{
    ui->setupUi(this);
    init();
    createMenus();
    
    // Add Ctrl+Q hotkey for quit.
    (void) new QShortcut(Qt::CTRL + Qt::Key_Q, this, SLOT(close()));

    this->sm = new ServiceMgr(this);

    connect(sm, SIGNAL(errorOccured(QString, QTransport::Action)), this, SLOT(gotErrorMsg(QString, QTransport::Action)));

    panel = new ImageBrowserPanel(this->sm, this);
    panel->setFont(this->usedFont);
    this->setCentralWidget(panel);

    connect(panel, SIGNAL(openImage(Photo)), this, SLOT(openImage(Photo)));

    this->settingsUpdated();

    // check that one acount mast be setup
    if (this->sm->getAccounts().length() == 0) {
        UIAccountSettings *settings = new UIAccountSettings(this->sm, this);
        settings->setModal(true);
        settings->addNewAccount();
    }

}

VKGallery::~VKGallery()
{
    delete ui;
    delete sm;
}

void VKGallery::init()
{
#ifdef Q_WS_MAEMO_5
    this->usedFont = QFont(this->font().family(), 14);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    this->fullScreenButton = new FullScreenExitButton(this);
    this->fullScreenButton->hide();
#else
    this->usedFont = this->font();
#endif
}

void VKGallery::createMenus()
{
    // main menu
    QMenu *mmenu = menuBar()->addMenu(tr("File"));
    QAction *action = mmenu->addAction(tr("Full screen"));
    connect(action, SIGNAL(triggered()), this, SLOT(actionFull_screen_toggled()));
#ifndef Q_WS_MAEMO_5
    action = mmenu->addAction(tr("Exit"));
    connect(action, SIGNAL(triggered()), this, SLOT(close()));
#endif

    // settings menu
#ifndef Q_WS_MAEMO_5
   mmenu = menuBar()->addMenu(tr("Settings"));
#endif
   action = mmenu->addAction(tr("Manage accounts"));
   connect(action, SIGNAL(triggered()), this, SLOT(actionAccSettings_toggled()));
   action = mmenu->addAction(tr("Network settings"));
   connect(action, SIGNAL(triggered()), this, SLOT(actionNetSettings_toggled()));
   action = mmenu->addAction(tr("Program settings"));
   connect(action, SIGNAL(triggered()), this, SLOT(actionAppSettings_toggled()));

   // help menu
#ifndef Q_WS_MAEMO_5
   mmenu = menuBar()->addMenu(tr("Help"));
#endif
   action = mmenu->addAction(tr("Help"));
   connect(action, SIGNAL(triggered()), this, SLOT(help()));
   action = mmenu->addAction(tr("About"));
   connect(action, SIGNAL(triggered()), this, SLOT(about()));
}

void VKGallery::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void VKGallery::help()
{
    QString path;
#ifdef DOCDIR
    path = DOCDIR;
#else
    path = Utils::getDataDir() + "/doc/" + APP_NAME;
#endif
    uihelp *windowHelp = new uihelp(path + tr("/help.html"),
                                    tr("Help - %1").arg(APP_NAME), this->usedFont, this);
#ifdef Q_WS_MAEMO_5
    windowHelp->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    windowHelp->show();
}

void VKGallery::about()
{
    QString path;
#ifdef DOCDIR
    path = DOCDIR;
#else
    path = Utils::getDataDir() + "/doc/" + APP_NAME;
#endif
    uihelp *windowHelp = new uihelp(path + tr("/about.html"),
                                    tr("About - %1").arg(APP_NAME), this->usedFont,this);
#ifdef Q_WS_MAEMO_5
    windowHelp->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    windowHelp->show();
}

void VKGallery::actionFull_screen_toggled()
{
    bool isFullScreen = windowState() & Qt::WindowFullScreen;
    if (isFullScreen) {
#ifdef Q_WS_MAEMO_5
        fullScreenButton->hide();
#endif
        showNormal();
    } else {
        showFullScreen();
#ifdef Q_WS_MAEMO_5
        fullScreenButton->show();
#endif
    }
}

void VKGallery::actionAccSettings_toggled()
{
    UIAccountSettings *settings = new UIAccountSettings(this->sm, this);
    settings->setModal(true);
    settings->show();
}

void VKGallery::actionNetSettings_toggled()
{
    UINetworkSettings *settings = new UINetworkSettings(this->sm, this);
    settings->setModal(true);
    settings->show();
}

void VKGallery::actionAppSettings_toggled()
{
    UIApplicationSettings *settings = new UIApplicationSettings(this->sm, this);
    connect(settings, SIGNAL(updateSettings()), this, SLOT(settingsUpdated()));
    settings->setModal(true);
    settings->show();
}

void VKGallery::gotErrorMsg(QString errorMsg, QTransport::Action acc) {
#ifdef Q_WS_MAEMO_5
//hildon_banner_show_information(0, "", errorMsg.toUtf8().data());
    QDBusMessage msg = QDBusMessage::createMethodCall("org.freedesktop.Notifications", "/org/freedesktop/Notifications",
                                                     "org.freedesktop.Notifications", "SystemNoteDialog");

    QList<QVariant> args;
    args.append(errorMsg);
    args.append(static_cast<quint32>(0));
    args.append("ok");

    msg.setArguments(args);

    QDBusConnection::systemBus().call(msg);
#else
    NotifyNotification *notification;
    /* Create notification */
    notification = notify_notification_new(APP_NAME,
        errorMsg.toUtf8().data(), NULL, NULL);
    if (notification) {
        /* Set timeout */
        notify_notification_set_timeout(notification, 3000);
        /* Schedule notification for showing */
        if (!notify_notification_show(notification, NULL))
            qDebug("Failed to send notification");

        /* Clean up the memory */
        g_object_unref(notification);
    } else
        qDebug("Failed to create notification");
//    QMessageBox::warning(this, tr("Error occured"),
//                             errorMsg);
#endif

    if (acc == QTransport::getListFriendsAction)
    {
        //this->isFriendsUpdate = false;
        //buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    }
    if (acc == QTransport::getListAlbumsAction)
    {
        //this->isAlbumsUpdate = false;
        //buttonRefreshAlbums->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    }
    if (acc == QTransport::getListPhotosAction)
    {
        //this->isPhotosUpdate = false;
        //buttonRefreshPhotos->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    }
}

void VKGallery::openImage(Photo photo)
{
    QImageViewer *viewer = new QImageViewer(this->font(), this);

#ifdef Q_WS_MAEMO_5
    viewer->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    viewer->loadImage(this->sm, photo);
}

void VKGallery::settingsUpdated()
{
    this->sm->settings->sync();

#ifdef Q_WS_MAEMO_5
    if (this->sm->settings->value(SETTINGS_AUTOROTATE).toBool())
    {
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    } else {
        setAttribute(Qt::WA_Maemo5AutoOrientation, false);
    }
#endif
}
