#ifndef UISETTINGS_H
#define UISETTINGS_H

#include <QDialog>

#include "servicemgr.h"
#include "account.h"
#include "driverinfo.h"
#include "uiaddaccount.h"

namespace Ui {
    class UISettings;
}

class UISettings : public QDialog
{
    Q_OBJECT

public:
    explicit UISettings(ServiceMgr *sm, QWidget *parent = 0);
    ~UISettings();

    /**
     * @brief shows settings page with add new account form
     *
    */
    void addNewAccount();

private:
    Ui::UISettings *ui;

    ServiceMgr *sm;

private slots:
    /**
     * @brief pass done button (store settings, etc.)
     *
    */
    void on_buttonBox_accepted();

    void on_btnAddNew_clicked();

    void updateAccounts(AccountList);

    void selectAccount();

    void on_btnRemove_clicked();

    void on_btnReconnect_clicked();
};

#endif // UISETTINGS_H
