/*
** nd_interface.h
** 
** Made by kulakov Kirill
** Login   <kulakov@seeker-netbook>
** 
** Started on  Fri Jan 29 16:48:45 2010 kulakov Kirill
** Last update Tue Feb  2 15:47:45 2010 kulakov Kirill
*/

#ifndef   	ND_INTERFACE_H_
# define   	ND_INTERFACE_H_

#include <glib.h>

void nd_getFriendImage(gchar *friendID);

void nd_getSend(gchar *from, gchar *to, gchar *offset);

void nd_getThreads(gchar *from, gchar *to);

void nd_getThreadMessages(gchar* friendID, gchar *from, gchar *to);

void nd_getInbox(gchar *from, gchar *to, gchar *offset);

void nd_getWall(gchar *from, gchar *to, gchar *friendID);

void nd_getInboxCount();

void nd_getSendCount();

void nd_getWallCount(gchar *friendID);

void nd_getInboxCountTime(gchar *from);

void nd_getSendCountTime(gchar *from);

void nd_getFriendInfo(gchar *friendID);

void nd_getFriends(gchar *from, gchar *to);

void nd_getAlbums(gchar *id);

void nd_createAlbum(gchar *friendID, gchar *title, gchar *description, gchar *privacy);

void nd_uploadPhoto(gchar *aid, gchar *file, gchar *file_name);

void nd_getPhotos(gchar* friendID,gchar* aid, gchar *from, gchar *to);

void nd_getUserPhotos(gchar* friendID, gchar *from, gchar *to);

void nd_getPhotoTags(gchar* id, gchar* album_id, gchar* photo_id);

void nd_getFavoritePhotos(gchar* friendID, gchar *from, gchar *to);

void nd_getPhotosUpdates(gchar* friendID);

void nd_getPhotoComments(gchar* id, gchar* album_id, gchar* photo_id, gchar* from, gchar* to);

void nd_sendPhotoComment(gchar* id, gchar* album_id, gchar* photo_id, gchar* text);

void nd_downloadPhoto(gchar* file_name, gchar* url);

void nd_getAudio(gchar *id);

void nd_init(gchar *proxyhost, gint proxyport);

void nd_get_settings();

void nd_get_methods();

void nd_set_settings(gchar *params);

void nd_getProfile();

void nd_getBaseProfile();

void nd_sendMessage(gchar* recipient_id, gchar* url_encoded_text);

void nd_sendWallMessage(gchar* recipient_id, gchar* url_encoded_text);

void nd_getNewInbox();

void nd_getNews(gchar *from, gchar *to, gchar *offset, gchar *title);

gint cur_events(xmlChar *data);

#endif 	    /* !ND_INTERFACE_H_ */
