/*
** nd_interface.c
** 
** Made by (kulakov Kirill)
** Login   <kulakov@seeker-netbook>
** 
** Started on  Fri Jan 29 16:50:46 2010 kulakov Kirill
** Last update Tue Feb  2 18:43:42 2010 kulakov Kirill
*/

#include <glib.h>
#include <stdlib.h>
#include <stdio.h>

#include "mysocials_driver.h"
#include "console.h"
#include "nd_interface.h"

void nd_getFriendImage(gchar *url)
{
    g_debug("%s:%d: Call nd_getFriendImage(%s)", __FILE__, __LINE__, url);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"binaryData\" function = \"getBinaryData\">\
<Params>\
<img name=\"Img\" uri=\"", url, "\"/>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);

}

void nd_getThreads(gchar *from, gchar *to)
{
    g_debug("%s:%d: Call nd_getThreads()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getListThreads\"> \
<Params>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getThreadMessages(gchar *friendID, gchar *from, gchar *to)
{
    g_debug("%s:%d: Call nd_getThreadMessages()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getListThreadMessages\"> \
<Params>\
<string name=\"threadId\">", friendID,"</string>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getSend(gchar *from, gchar *to, gchar *offset)
{
    g_debug("%s:%d: Call nd_getSend()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getListOutboxMessages\"> \
<Params>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
<number name=\"timeOffset\">", offset,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getInbox(gchar *from, gchar *to, gchar *offset)
{
    g_debug("%s:%d: Call nd_getInbox()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getListInboxMessages\">\
<Params>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
<number name=\"timeOffset\">", offset,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getWall(gchar *from, gchar *to, gchar *friendID)
{
    g_debug("%s:%d: Call nd_getWall()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getListWallMessages\"> \
<Params id=\"", friendID ,"\">\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getInboxCount()
{
    g_debug("%s:%d: Call nd_getInboxCount()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getTotalCountInbox\">\
<Params>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getSendCount()
{
    g_debug("%s:%d: Call nd_getSendCount()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getTotalCountOutbox\">\
<Params>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getWallCount(gchar *friendID)
{
    g_debug("%s:%d: Call nd_getWallCount()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getTotalCountWall\">\
<Params id=\"", friendID ,"\">\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getInboxCountTime(gchar* from)
{
    g_debug("%s:%d: Call nd_getInboxCountTime()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getCountInboxByTime\">\
<Params>\
<number name=\"timeOffset\">", from,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getSendCountTime(gchar* from)
{
    g_debug("%s:%d: Call nd_getSendCountTime()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getCountOutboxByTime\">\
<Params>\
<number name=\"timeOffset\">", from,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_delMessage(gchar *messageID)
{
    g_debug("%s:%d: Call nd_delMessage()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"deleteMessage\">\
<Params/>\
<string name=\"messageId\">", messageID, "</string>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_delWallMessage(gchar *messageID)
{
    g_debug("%s:%d: Call nd_delMessage()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"deleteWallMessage\">\
<Params/>\
<string name=\"messageId\">", messageID, "</string>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_readMessage(gchar *messageID)
{
    g_debug("%s:%d: Call nd_readMessage()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"readMessage\">\
<Params/>\
<string name=\"messageId\">", messageID, "</string>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}


void nd_getFriendInfo(gchar *friendID)
{
    g_debug("%s:%d: Call nd_getFriendInfo(%s)", __FILE__, __LINE__, friendID);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"profile\" function = \"getProfile\">\
<Params id=\"", friendID,"\">\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
    
}

void nd_delFriend(gchar *friendID)
{
    g_debug("%s:%d: Call nd_delFriend(%s)", __FILE__, __LINE__, friendID);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"friends\" function = \"deleteFriend\">\
<Params id=\"", friendID,"\">\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);

}


void nd_getFriends(gchar *from, gchar *to)
{
    g_debug("%s:%d: Call nd_getFriends()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"friends\" function=\"getListFriends\">\
<Params>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    /* g_free(req); */
    xmlFreeDoc(resp);
}

void nd_getAlbums(char *id)
{
    g_debug("%s:%d: Call nd_getAlbums()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function=\"getListAlbums\">\
<Params id=\"", id,
"\"></Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    /* g_free(req); */
    xmlFreeDoc(resp);
}

void nd_uploadPhoto(gchar *aid, gchar *file, gchar *file_name)
{
    g_debug("%s:%d: Call nd_uploadPhoto()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function=\"uploadPhoto\">\
<Params>\
<string name=\"albumId\">", aid, "</string>\
<string name=\"file\">", file, "</string>\
<string name=\"fileName\">", file_name, "</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    /* g_free(req); */
    xmlFreeDoc(resp);
}

void nd_getPhotos(gchar* friendID, gchar* aid, gchar *from, gchar *to)
{
    g_debug("%s:%d: Call nd_getPhotos()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"getListPhotos\">\
<Params id=\"", friendID, "\">\
<string name=\"albumId\">", aid ,"</string>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getUserPhotos(gchar* friendID, gchar *from, gchar *to)
{
    g_debug("%s:%d: Call nd_getUserPhotos()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
"<Request class=\"photos\" function = \"getListUserPhotos\">\
<Params id=\"", friendID, "\">\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getPhotoTags(gchar* id, gchar* album_id, gchar* photo_id)
{
    g_debug("%s:%d: Call nd_getPhotoTags()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"getListPhotoTags\">\
<Params>\
<string name=\"ownerId\">",id,"</string>\
<string name=\"albumId\">",album_id,"</string>\
<string name=\"photoId\">",photo_id,"</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getFavoritePhotos(gchar* friendID, gchar *from, gchar *to)
{
    g_debug("%s:%d: Call nd_getUserPhotos()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
"<Request class=\"photos\" function = \"getListFavoritePhotos\">\
<Params id=\"", friendID, "\">\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}
void nd_getPhotosUpdates(gchar* friendID)
{
    g_debug("%s:%d: Call nd_getPhotosUpdates()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"getPhotosUpdates\">\
<Params id=\"", friendID, "\">\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getPhotoComments(gchar* id, gchar* album_id, gchar* photo_id, gchar* from, gchar* to)
{
    g_debug("%s:%d: Call nd_getPhotoComments()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"getListPhotoComments\">\
<Params>\
<string name=\"ownerId\">",id,"</string>\
<string name=\"albumId\">",album_id,"</string>\
<string name=\"photoId\">",photo_id,"</string>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_sendPhotoComment(gchar* id, gchar* album_id, gchar* photo_id, gchar* file)
{
    g_debug("%s:%d: Call nd_sendPhotoComment()", __FILE__, __LINE__);
    gchar* text;
    g_file_get_contents(file, &text, NULL, NULL);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"sendPhotoComment\">\
<Params>\
<string name=\"ownerId\">",id,"</string>\
<string name=\"albumId\">",album_id,"</string>\
<string name=\"photoId\">",photo_id,"</string>\
<string name=\"text\">",text,"</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_createAlbum(gchar *friendID, gchar *title, gchar *description, gchar *privacy)
{
    g_debug("%s:%d: Call nd_createAlbum()", __FILE__, __LINE__);
    gchar* text = NULL, *text2 = NULL;
    g_file_get_contents(title, &text, NULL, NULL);
    g_file_get_contents(description, &text2, NULL, NULL);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"createAlbum\">\
<Params id=\"", friendID, "\">\
<string name=\"name\">",text,"</string>\
<string name=\"description\">",text2,"</string>\
<string name=\"privacy\">",privacy,"</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(text);
    g_free(text2);
    xmlFreeDoc(resp);
}

void nd_downloadPhoto(gchar* file_name, gchar* url)
{
    g_debug("%s:%d: Call nd_downloadPhoto()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"photos\" function = \"getPhoto\">\
<Params>\
<string name=\"path\">", file_name ,"</string>\
<string name=\"url\">", url ,"</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getAudio(char *id)
{
    g_debug("%s:%d: Call nd_getAudio()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"audio\" function=\"getListAudio\">\
<Params id=\"", id,
"\"></Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    /* g_free(req); */
    xmlFreeDoc(resp);
}

/* initialize connection params */
void nd_init(gchar *proxyhost, gint proxyport)
{
    g_debug("%s:%d: Call nd_init()", __FILE__, __LINE__);
    driver_module->proxy = proxyhost;
    driver_module->port = proxyport;
    
}

void nd_get_settings()
{
    g_debug("%s:%d: Call nd_get_settings()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"settings\" function = \"getSettings\">\
<Params/>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_test_connection()
{
    g_debug("%s:%d: Call nd_test_connection()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
"<Request class=\"settings\" function = \"testConnection\">\
<Params/>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}
void nd_get_methods()
{
    g_debug("%s:%d: Call nd_get_methods()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"settings\" function = \"getListMethods\">\
<Params/>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_set_settings(gchar *params)
{
    g_debug("%s:%d: Call nd_set_settings()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"settings\" function = \"setSettings\">", params, "</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_getProfile()
{
    g_debug("%s:%d: Call nd_getProfile()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request noAuthorize=\"false\" class=\"profile\" function = \"getProfile\">\
<Params/>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);

}

void nd_getBaseProfile()
{
    g_debug("%s:%d: Call nd_getBaseProfile()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"profile\" function = \"getBaseProfile\">\
<Params/>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);

}

/*
void nd_setProfile()
{
    g_debug("%s:%d: Call nd_setProfile()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
"<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"profile\" function = \"setProfile\">\
<Params>\
<string name=\"FirstName\">", name, "</string>\
<string name=\"LastName\">", surname, "</string>\
<struct name=\"City\">\
<string name=\"CityId\">", city_id, "</string>\
</struct>\
<struct name=\"Country\">\
<string name=\"CountryId\">", country_id, "</string>\
</struct>\
<date name=\"Birthday\">", birthday, "</date>\
<select name=\"Gender\">\
<string selected=\"1\">", gender, "</string>\
</select>\
<select name=\"FamilyState\">\
<string selected=\"1\">", family, "</string>\
</select>\
<select name=\"PoliticalView\">\
<string selected=\"1\">", politic, "</string>\
</select>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);

}
*/
void nd_sendMessage(gchar* recipient_id, gchar* url_encoded_text)
{
    g_debug("%s:%d: Call nd_sendMessag()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"sendMessage\">\
<Params id=\"", recipient_id, "\">\
<string name=\"text\">", url_encoded_text, "</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

void nd_sendWallMessage(gchar* recipient_id, gchar* url_encoded_text)
{
    g_debug("%s:%d: Call nd_sendMessag()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"sendWallMessage\">\
<Params id=\"", recipient_id, "\">\
<string name=\"text\">", url_encoded_text, "</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}
void nd_getNewInbox()
{
    g_debug("%s:%d: Call nd_getNewInbox()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"messages\" function = \"getNewInboxMessages\">\
<Params/>\
</Request>", NULL);

    xmlDocPtr req = xmlParseDoc(req_string);
	
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);				
}

void nd_getNews(gchar *from, gchar *to, gchar *offset, gchar *title)
{
    g_debug("%s:%d: Call nd_getNews()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<Request class=\"news\" function = \"getListNews\">\
<Params>\
<number name=\"page\">", from,"</number>\
<number name=\"pageSize\">", to,"</number>\
<number name=\"timeOffset\">", offset,"</number>\
<string name=\"newsType\">", title,"</string>\
</Params>\
</Request>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    xmlFreeDoc(resp);
}

gint cur_events(xmlChar *data)
{
    g_debug("Called cur_events()");
    if (data != NULL)
    {
	fprintf(stdout, "=========================== cur_events ======================\n");
	fprintf(stdout, "%s", data);
    }
    return 0;
}

