/*
** nd_interface.c
** 
** Made by (kulakov Kirill)
** Login   <kulakov@seeker-netbook>
** 
** Started on  Fri Jan 29 16:50:46 2010 kulakov Kirill
** Last update Tue Feb  2 18:43:42 2010 kulakov Kirill
*/

#include <glib.h>
#include <stdlib.h>
#include <stdio.h>

#include "mysocials_driver.h"
#include "console.h"
#include "nd_interface.h"

void nd_getFriendImage(gchar *url)
{
    g_debug("%s:%d: Call nd_getFriendImage(%s)", __FILE__, __LINE__, url);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"binaryData\" function = \"getBinaryData\">\
<Params>\
<img name=\"Img\" uri=\"", url, "\"/>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);

}

void nd_getSend()
{
    g_debug("%s:%d: Call nd_getSend()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"messages\" function = \"updateOutboxMessages\"> \
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);
}

void nd_getInbox()
{
    g_debug("%s:%d: Call nd_getInbox()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"messages\" function = \"updateInboxMessages\">\
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);
}

void nd_getFriendInfo(gchar *friendID)
{
    g_debug("%s:%d: Call nd_getFriendInfo(%s)", __FILE__, __LINE__, friendID);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"profile\" function = \"updateProfile\">\
<Params id=\"", friendID,"\">\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);
    
}

void nd_getFriends()
{
    g_debug("%s:%d: Call nd_getFriends()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"friends\" function=\"updateListFriends\">\
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    /* g_free(req); */
    g_free(resp);
}

/* initialize connection params */
void nd_init(gchar *proxyhost, gint proxyport)
{
    g_debug("%s:%d: Call nd_init()", __FILE__, __LINE__);
    driver_module->proxy = proxyhost;
    driver_module->port = proxyport;
    
}

void nd_get_settings()
{
    g_debug("%s:%d: Call nd_get_settings()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"settings\" function = \"getSettings\">\
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);
}

void nd_set_settings(gchar *login, gchar *password, gchar *autoupdate, gchar *active)
{
    g_debug("%s:%d: Call nd_set_settings()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData>\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"settings\" function = \"setSettings\">\
<Params>\
<string name=\"login\">", login, "</string>\
<string name=\"password\">", password, "</string>\
<number name=\"autoupdate\">", autoupdate, "</number>\
<boolean name=\"active\">", active, "</boolean>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);
    
    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);
}

void nd_getProfile()
{
    g_debug("%s:%d: Call nd_getProfile()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"profile\" function = \"updateProfile\">\
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);

}
/*
void nd_setProfile()
{
    g_debug("%s:%d: Call nd_setProfile()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
"<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"profile\" function = \"setProfile\">\
<Params>\
<string name=\"FirstName\">", name, "</string>\
<string name=\"LastName\">", surname, "</string>\
<struct name=\"City\">\
<string name=\"CityId\">", city_id, "</string>\
</struct>\
<struct name=\"Country\">\
<string name=\"CountryId\">", country_id, "</string>\
</struct>\
<date name=\"Birthday\">", birthday, "</date>\
<select name=\"Gender\">\
<string selected=\"1\">", gender, "</string>\
</select>\
<select name=\"FamilyState\">\
<string selected=\"1\">", family, "</string>\
</select>\
<select name=\"PoliticalView\">\
<string selected=\"1\">", politic, "</string>\
</select>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    driver_module->send(req, &resp, driver_module);

    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);

}
*/
void nd_sendMessage(gchar* recipient_id, gchar* url_encoded_text)
{
    g_debug("%s:%d: Call nd_sendMessag()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"messages\" function = \"sendMessage\">\
<Params id=\"", recipient_id, "\">\
<string name=\"text\">", url_encoded_text, "</string>\
</Params>\
</Request>\
</Content>\
</TransitData>", NULL);
    xmlDocPtr req = xmlParseDoc(req_string);

    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);
}

void nd_getNewInbox()
{
    g_debug("%s:%d: Call nd_getNewInbox()", __FILE__, __LINE__);
    gchar *req_string = g_strconcat("<?xml version=\"1.0\"?>",
    "<TransitData id=\"1\" type=\"data\">\
<SourceID>console</SourceID>\
<TargetID>vkontakte</TargetID>\
<Content>\
<Request class=\"messages\" function = \"getNewInboxMessages\">\
<Params/>\
</Request>\
</Content>\
</TransitData>", NULL);

    xmlDocPtr req = xmlParseDoc(req_string);
	
    xmlDocPtr resp = NULL;

    /* process request */
    driver_module->send(req, &resp, driver_module);

    /* clear memory */
    xmlDocDump(stdlog, resp);
    g_free(req_string);
    g_free(resp);				
}

gint cur_events(xmlChar *data)
{
    g_debug("Called cur_events()");
    if (data != NULL)
    {
	fprintf(stdout, "=========================== cur_events ======================\n");
	fprintf(stdout, "%s", data);
    }
    return 0;
}
