#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

#include "getopt_args.h"
#include "console.h"
#include "mysocials_driver.h"
#include "nd_interface.h"
#include "messages.h"

#define _GNU_SOURCE

gchar *progname = NULL;
gchar *login = NULL;
gchar *password = NULL;
gchar *autoupdate = NULL;
gchar *active = NULL;
gchar *proxy = NULL;
gint port = 0;

/*pointer to social network driver library */
void *handle = NULL;

/* Name of file with command sequence */
gchar *command_file = NULL;

gchar *log_file = NULL;

/* Path to library of social network driver */
gchar *driver = NULL;

/* Struct driver_info contains links for used functions */
msa_module *driver_module = NULL;

gint (*driver_init)(msa_module *);

FILE *stdlog = NULL;

gint main(gint argc, gchar *argv[])
{
    setlocale(LC_ALL, "");
    gchar *error = bindtextdomain("mysocials-console", "./po/");
    g_debug("bindtextdomain: %s", error);
    error = bind_textdomain_codeset("mysocials-console", "UTF-8");
    g_debug("bind_textdomain_codeset: %s", error);
    error = textdomain("mysocials-console");
    g_debug("textdomain: %s", error);



    FILE * inStream = stdin;

    gchar *curCommand =  NULL; 
    gchar *friendID = NULL;
    gchar *url = NULL;
    gchar* recipient_id = NULL;
    gchar* text = NULL;
    gchar* url_encoded_text = NULL;
    
    error = NULL;

    curCommand = (gchar *)g_malloc(sizeof(gchar) * 255);
    friendID = (gchar *)g_malloc(sizeof(gchar) * 255);
    url = (gchar *)g_malloc(sizeof(gchar) * 255);
    
    if (curCommand == NULL || friendID == NULL || url == NULL)
	g_error(ERR_MEM, __FILE__, __LINE__);
    
    
    progname = argv[0];
    parse_args(argc, argv);

    /* load driver */
    handle = dlopen(driver, RTLD_LAZY);
    if (handle == NULL)
    {
	g_warning("can't load driver: %s", dlerror());
	exit(EXIT_FAILURE);
    }

    dlerror();

    if (NULL == (driver_module = g_malloc(sizeof(msa_module))))
    {
	g_error(ERR_MEM, __FILE__, __LINE__);
    }
    driver_module->set_events = cur_events;

    *(void **) (&driver_init) = dlsym(handle, MODULE_INIT);
    (*driver_init)(driver_module);

    if ((error = dlerror()) != NULL)  {
	fprintf(stderr, "%s\n", error);
	exit(EXIT_FAILURE);
    }

    /* open command stream */
    if (command_file != NULL)
    {
	inStream = freopen(command_file, "r", inStream);
    }

    if (inStream == NULL)
    {
	g_error(_("can't read input stream"));
    }

    if (log_file != NULL)
    {
	stdlog = fopen(log_file, "w");
	if (stdlog == NULL)
	    g_error("can't open log file");
    }else
	stdlog = stdout;
    
   /* parsing command file */
    g_debug(_("Parse command file"));
    gint retNum = 0;

    while ((retNum = fscanf(inStream, "%254s", curCommand)) != EOF)
    {
	if (retNum != 1)
	    break;

	fprintf(stdlog, "=========================== %s ==========================\n", curCommand);

	if (strcmp(curCommand, "INIT") == 0)
	{
	    /* read proxy host */
	    if (fscanf(inStream, "%254s", curCommand) <=0)
		g_error("wrong INIT: proxy host");
		
	    if (proxy == NULL)
		proxy = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
	    else
		proxy = g_realloc(proxy, sizeof(gchar) * (strlen(curCommand) + 1));
	    if (proxy == NULL)
		g_error(ERR_MEM, __FILE__, __LINE__);
		
	    g_strlcpy(proxy, curCommand, strlen(curCommand) + 1);
	    g_debug("%s:%d: proxy=%s", __FILE__, __LINE__, proxy);
	    
	    /* read proxy port */
	    if (fscanf(inStream, "%254s", curCommand) <=0)
		g_error("wrong INIT: proxy port");
		
	    error = curCommand;
	    port = strtol(curCommand, &error, 10);
	    if (*error != '\0')
		g_error("Can't parse proxy port number");
	    g_debug("%s:%d: port=%d", __FILE__, __LINE__, port);

	    nd_init(proxy, port);
	    continue;
	}

	if (strcmp(curCommand, "GETSETTINGS") == 0)
	{
	    nd_get_settings();
	    continue;
	}

	if (strcmp(curCommand, "SETSETTINGS") == 0)
	{
	    /* read login */
	    if (fscanf(inStream, "%254s", curCommand) <=0)
		g_error("wrong GETSETTINGS:login");
		
	    if (login == NULL)
		login = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
	    else
		login = g_realloc(login, sizeof(gchar) * (strlen(curCommand) + 1));
	    if (login == NULL)
		g_error(ERR_MEM, __FILE__, __LINE__);
		
	    g_strlcpy(login, curCommand, strlen(curCommand) + 1);
	    g_debug("%s:%d: login=%s", __FILE__, __LINE__, login);
	    
	    /* read password */
	    if (fscanf(inStream, "%254s", curCommand) <=0)
		g_error("wrong GETSETTINGS:password");
	    if (password == NULL)
		password = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
	    else
		password = g_realloc(password, sizeof(gchar) * (strlen(curCommand) + 1));
	    if (password == NULL)
		g_error(ERR_MEM, __FILE__, __LINE__);
		
	    g_strlcpy(password, curCommand, strlen(curCommand) + 1);
	    g_debug("%s:%d: password=%s", __FILE__, __LINE__, password);

            /* read autoupdate */
            if (fscanf(inStream, "%254s", curCommand) <=0)
                g_error("wrong GETSETTINGS:autoupdate");

            if (autoupdate == NULL)
                autoupdate = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
            else
                autoupdate = g_realloc(login, sizeof(gchar) * (strlen(curCommand) + 1));
            if (autoupdate == NULL)
                g_error(ERR_MEM, __FILE__, __LINE__);

            g_strlcpy(autoupdate, curCommand, strlen(curCommand) + 1);
            g_debug("%s:%d: autoupdate=%s", __FILE__, __LINE__, autoupdate);	    
	    

            /* read active */
            if (fscanf(inStream, "%254s", curCommand) <=0)
                g_error("wrong GETSETTINGS:active");

            if (active == NULL)
                active = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
            else
                active = g_realloc(login, sizeof(gchar) * (strlen(curCommand) + 1));
            if (active == NULL)
                g_error(ERR_MEM, __FILE__, __LINE__);

            g_strlcpy(active, curCommand, strlen(curCommand) + 1);
            g_debug("%s:%d: active=%s", __FILE__, __LINE__, active);
	    
	    nd_set_settings(login, password, autoupdate, active);
	    continue;
	}

	if (strcmp(curCommand, "GETFRIENDS") == 0)
	{
	    nd_getFriends();
	    continue;
	}

	if (strcmp(curCommand, "GETFRIENDINFO") == 0)
	{
	    if (fscanf(inStream, "%254s", friendID) != EOF)
		nd_getFriendInfo(friendID);
	    continue;
	}

	if (strcmp(curCommand, "GETINBOX") == 0)
	{
	    nd_getInbox();
	    continue;
	}

	if (strcmp(curCommand, "GETSEND") == 0)
	{
	nd_getSend();
	    continue;
	}

	if (strcmp(curCommand, "GETIMAGE") == 0)
	{
	    if (fscanf(inStream, "%254s", url) != EOF)
		nd_getFriendImage(url);
	    continue;
	}

	if (strcmp(curCommand, "SETLOGIN") == 0)
	{
	    if (1 != fscanf(inStream, "%254s", login))
		g_error("Can't read login value");
	    continue;
	}

	if (strcmp(curCommand, "SETPASSWORD") == 0)
	{
	    if (1 != fscanf(inStream, "%254s", password))
		g_error("Can't read password value");
	    continue;
	}

	if (strcmp(curCommand, "GETPROFILE") == 0)
	{
	    nd_getProfile();
            continue;
	}

        if (strcmp(curCommand, "SETPROFILE") == 0)
        {

            //nd_setProfile();
            continue;
        } 
     
        if (strcmp(curCommand, "SENDMESSAGE") == 0)
        {
            /* read recipient_id */
            if (fscanf(inStream, "%254s", curCommand) <=0)
                g_error("wrong GETSETTINGS:recipient_id");

            if (recipient_id == NULL)
                recipient_id = g_malloc(sizeof(gchar) * (strlen(curCommand) + 1));
            else
                recipient_id = g_realloc(login, sizeof(gchar) * (strlen(curCommand) + 1));
            if (recipient_id == NULL)
                g_error(ERR_MEM, __FILE__, __LINE__);

            g_strlcpy(recipient_id, curCommand, strlen(curCommand) + 1);
            g_debug("%s:%d: recipient_id=%s", __FILE__, __LINE__, recipient_id);

            /* read text */
	    size_t* size;
            if (-1 == getdelim(&text, size, '=', inStream))
        	g_error("Can't read message text");
            CURL* curl;
	    
	    if(text != NULL)
            {
                url_encoded_text = curl_easy_escape(curl, text+1, strlen(text)-2);
                nd_sendMessage(recipient_id, url_encoded_text);
	    }
            
            continue;
        }

	if (strcmp(curCommand, "GETNEWINBOX") == 0)
        {
            nd_getNewInbox();
            continue;
        }
	
	g_warning(_("Can't recognize command \"%s\"\n"), curCommand);
    }

    g_debug(_("Process comleted. Closing..."));
    if (driver_module->shutdown != NULL)
	driver_module->shutdown();

    /* clean used memory */
    if (curCommand != NULL)
	g_free(curCommand);

    if (friendID != NULL)
	g_free(friendID);

    if (url != NULL)
        g_free(url);

    if (recipient_id != NULL)
        g_free(recipient_id);

    if (text != NULL)
        g_free(text);

    if (url_encoded_text != NULL)
        g_free(url_encoded_text);

    if (login != NULL)
        g_free(login);

    if (password != NULL)
	g_free(password);

    if (command_file != NULL)
	g_free(command_file);

    if (log_file != NULL)
	g_free(log_file);

    if (driver_module != NULL)
    {
	g_free(driver_module->name);
	g_free(driver_module->id);
	g_free(driver_module);
    }
    

    dlclose(handle);

    return EXIT_SUCCESS;
}
