#include <QTest>

#include "qfriendtest.h"

void QFriendTest::init()
{
    this->fr = new Friend();
}

void QFriendTest::cleanup()
{
    delete this->fr;
    this->fr = NULL;
}

void QFriendTest::emptyFields()
{
    QVERIFY(this->fr->firstName().isEmpty());
    QVERIFY(this->fr->nickName().isEmpty());
    QVERIFY(this->fr->lastName().isEmpty());
}

void QFriendTest::firstName()
{
    this->fr->setFirstName(" ");
    QVERIFY(this->fr->name().compare(" ") == 0);

    this->fr->setFirstName(QString::null);
    QVERIFY(this->fr->name().isEmpty());

    this->fr->setFirstName(" ");
    this->fr->setNickName("123");
    QVERIFY(this->fr->name().compare(" ") == 0);
}
