# -------------------------------------------------
# Project created by QtCreator 2010-08-12T14:46:35
# -------------------------------------------------
QT = gui \
    core \
    xml \
    network

TARGET_NAME = mysocials

unix: { 
    TARGET = $${TARGET_NAME}
} else {
    TARGET = $$qtLibraryTarget($$TARGET_NAME)
}

VERSION = 1.2.0

TEMPLATE = lib

# include private developer settings
exists(../devel.pri):include(../devel.pri)

CONFIG += link_pkgconfig \
    thread
    
isEmpty(ENABLE_DEBUG): CONFIG += release
!isEmpty(ENABLE_DEBUG): CONFIG += debug

PKGCONFIG += libxml-2.0 \
    glib-2.0

DEFINES += mysocials_LIBRARY

OBJECTS_DIR = build

DEFINES += LOCALDATADIR=\\\"/.msa/\\\"

# meego harmattan sdk defines
exists($$QMAKE_INCDIR_QT"/../qmsystem2/qmkeys.h"):!contains(MEEGO_EDITION,harmattan): {
  MEEGO_VERSION_MAJOR     = 1
  MEEGO_VERSION_MINOR     = 2
  MEEGO_VERSION_PATCH     = 0
  MEEGO_EDITION           = harmattan
  DEFINES += MEEGO_EDITION_HARMATTAN
}

isEmpty(PREFIX):PREFIX = $$[QT_INSTALL_PREFIX]
message(prefix is $$PREFIX)

DATAPREFIX = $$PREFIX/share
DEFINES += DATAPREFIX=\\\"$$DATAPREFIX\\\"
message(dataprefix is $$DATAPREFIX)
BINDIR = $$PREFIX/bin
LIBDIR = $$PREFIX/lib
!maemo5:!contains(MEEGO_EDITION,harmattan):contains(QMAKE_HOST.arch, x86_64)::LIBDIR = $$PREFIX/lib64
INCLUDEDIR = $$PREFIX/include
DATADIR = $$PREFIX/share

RESOURCES += ../data/mysocials_res.qrc

SOURCES += utils/utils.cpp \
    servicemgr.cpp \
    qtransport.cpp \
    datatypes/photo.cpp \
    datatypes/account.cpp \
    datatypes/friend.cpp \
    datatypes/album.cpp \
    datatypes/driverinfo.cpp \
    datatypes/message.cpp \
    datatypes/photocomments.cpp \
    datatypes/qerrormsg.cpp \
    datatypes/qeventfeed.cpp \
    datatypes/qattachment.cpp \
    filter/servicefilter.cpp \
    filter/filtermanager.cpp \
    filter/filter.cpp \
    filter/filterfriendonline.cpp \
    filter/filterfriendgender.cpp \
    filter/filtermessagereaded.cpp \
    filter/filtermessagetype.cpp \
    datatypes/qstatinfo.cpp \
    filter/filtermodel.cpp

HEADER_FILTERS = filter/servicefilter.h \
    filter/filtermanager.h \
    filter/filter.h \
    filter/filterfriendonline.h \
    filter/filterfriendgender.h \
    filter/filtermessagereaded.h \
    filter/filtermessagetype.h \
    filter/filtermodel.h

HEADER_CORE = mysocials_global.h \
    mysocials_driver.h \
    servicemgr.h \
    qtransport.h

HEADER_UTILS = utils/utils.h \
    utils/qrefreshlist.h

HEADER_DATATYPES = datatypes/photo.h \
    datatypes/account.h \
    datatypes/friend.h \
    datatypes/album.h \
    datatypes/driverinfo.h \
    datatypes/photocomments.h \
    datatypes/qerrormsg.h \
    datatypes/message.h \
    datatypes/qeventfeed.h \
    datatypes/qattachment.h \
    datatypes/qstatinfo.h

HEADERS += $$HEADER_DATATYPES \
    $$HEADER_UTILS \
    $$HEADER_CORE \
    $$HEADER_FILTERS

CODECFORSRC = UTF-8

TRANSLATIONS = ../translations/$${TARGET_NAME}_core_ru.ts

system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials:g;s:@VERSION@:$$VERSION:g' ../data/mysocials-dev.pc.in >../data/mysocials-dev.pc")
system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials:g;s:@VERSION@:$$VERSION:g' ../data/mysocials-core.pc.in >../data/mysocials-core.pc")

# make install
INSTALLS += target \
    pkgconfig \
    header_core \
    header_types \
    header_utils \
    header_filters \
    translations

target.path = $$LIBDIR

pkgconfig.path = $$LIBDIR/pkgconfig
pkgconfig.files = ../data/*.pc

translations.path = $$DATADIR/qt4/translations/
translations.files = ../translations/*.qm

header_core.path = $$INCLUDEDIR/mysocials
header_core.files = $$HEADER_CORE

header_types.path = $$INCLUDEDIR/mysocials/datatypes
header_types.files = $$HEADER_DATATYPES

header_filters.path = $$INCLUDEDIR/mysocials/filter
header_filters.files = $$HEADER_FILTERS

header_utils.path = $$INCLUDEDIR/mysocials/utils
header_utils.files = $$HEADER_UTILS

# library documentation
htmldocs.path = $$DATADIR/doc/mysocials-core
htmldocs.files = ../doc/html*
INSTALLS += htmldocs

qtdocs.path = $$DATADIR/qt4/doc/qch
qtdocs.files = ../doc/*.qch
INSTALLS += qtdocs


