#ifndef FILTERMODEL_H
#define FILTERMODEL_H

#include <QtGui/QSortFilterProxyModel>

class ServiceMgr;
class FilterManager;
class DriverInfo;
class ServiceFilter;

class FilterModel : public QSortFilterProxyModel
{
    Q_OBJECT
public:
    FilterModel(QObject* parent = 0);
    FilterModel(ServiceMgr* smgr, QObject* parent = 0);

    QString getServiceId(const QVariant& data) const;

protected:
    bool filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const;
    //bool lessThan(const QModelIndex& left, const QModelIndex& right) const;

public slots:
    void setFilteredDriver(DriverInfo* driver);
    void setFilterString(const QString& str);

private:
    ServiceMgr* mServiceMgr;
    FilterManager* mFilterMgr;
    ServiceFilter* mServiceFilter;
    QString mFilterString;

    DriverInfo* mFilteredDriver;
};

#endif // FILTERMODEL_H
