#ifndef FILTERMODEL_H
#define FILTERMODEL_H

#include <QtGui/QSortFilterProxyModel>

class ServiceMgr;
class FilterManager;
class DriverInfo;
class ServiceFilter;

class FilterModel : public QSortFilterProxyModel
{
    Q_OBJECT
public:
    FilterModel(ServiceMgr* smgr, QObject* parent = 0);

    QString getServiceId(const QVariant& data) const;

protected:
    bool filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const;

private slots:
    void setFilteredDriver(DriverInfo* driver);

private:
    ServiceMgr* mServiceMgr;
    FilterManager* mFilterMgr;
    ServiceFilter* mServiceFilter;

    DriverInfo* mFilteredDriver;
};

#endif // FILTERMODEL_H
