#include "filtermodel.h"

#include <QtCore/QDebug>

#include "servicemgr.h"
#include "filter/servicefilter.h"
#include "filter/filtermanager.h"
#include "datatypes/driverinfo.h"

FilterModel::FilterModel(ServiceMgr* smgr, QObject *parent) :
    QSortFilterProxyModel(parent), mServiceMgr(smgr),
    mFilterMgr(smgr->filterManager()), mServiceFilter(smgr->serviceFilter()),
    mFilteredDriver(0)
{
    setFilterRole(Qt::UserRole);
    setDynamicSortFilter(true);

    connect(mFilterMgr, SIGNAL(stateChanged()), SLOT(invalidate()));
    connect(mServiceFilter, SIGNAL(serviceSelected(DriverInfo*)), SLOT(setFilteredDriver(DriverInfo*)));
}

bool FilterModel::filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const
{
    QModelIndex index = sourceModel()->index(sourceRow, 0, sourceParent);

    QVariant data = index.data(filterRole());

    bool passServiceFilter = false;
    QString serviceId = getServiceId(data);

    if (mFilteredDriver == 0 || serviceId.isNull() || serviceId == mFilteredDriver->serviceName) {
        passServiceFilter = true;
    }

    return passServiceFilter && mFilterMgr->checkValue(data);
}

void FilterModel::setFilteredDriver(DriverInfo* driver)
{
    mFilteredDriver = driver;
    invalidate();
}

QString FilterModel::getServiceId(const QVariant& data) const
{
    if (data.canConvert<Friend>()) {
        return data.value<Friend>().serviceId();
    } else if (data.canConvert<Album>()) {
        QString accountId = data.value<Album>().accountId();
        return mServiceMgr->account(accountId)->serviceName();
    } else if (data.canConvert<Message>()) {
        QString accountId = data.value<Message>().accountId();
        return mServiceMgr->account(accountId)->serviceName();
    }

    // Doesn't have service id
    return QString();
}
