#ifndef UTILS_H
#define UTILS_H

#include <QString>
#include <QDir>
#include <QDomDocument>
#include <QDesktopServices>

#include "datatypes/photo.h"
#include "datatypes/album.h"

#define DATE_TIME_FORMAT "dd.MM.yyyy hh:mm:ss"

#define FRIEND_ICONS_DIR "friend_icons/"
#define ALBUM_ICONS_DIR "album_icons/"
#define DRIVER_LIBRARY_DIR "/msa/drivers/"

class QSettings;

/*!
  \brief Common functions and procedures

  This class contains common static functions which are used in other classes.
  */
class Utils
{
    static QSettings* settings;
public:
    /**
      \brief Default constructor
      */
    Utils();

    /**
      \brief Get home directory

      Function returns user's home directory

      \return Path to folder
      */
    static QString getHomeDir();

    /**
     \brief Get path to folder for friend icons corresponded the name of service

     \param serviceName the name of service

     \return Path to folder
    */
    static QString getFriendsIconDir(const QString& serviceName);

    /**
      \brief Get path to folder for friend icons corresponded the name of service

      \param serviceName the name of service

      \return Path to folder
      */
    static QString getFriendsIconDir(char * serviceName);

    /**
      \brief Get path to folder for album icons corresponded the name of service

      \param serviceName the name of service

      \return Path to folder
      */
    static QString getAlbumsIconDir(const QString& serviceName);

    /**
      \brief Get path to folder for album icons corresponded the name of service

      \param serviceName the name of service

      \return Path to folder
      */
    static QString getAlbumsIconDir(char * serviceName);

    /**
      \brief Get path to folder for image thumbnails corresponded the name of service

      \param serviceName the name of service

      \return Path to folder
      */
    static QString getPhotoDir(const QString& serviceName);

    /**
      \brief Get path to folder for image thumbnails corresponded the name of service

      \param serviceName the name of service

      \return Path to folder
      */
    static QString getPhotoDir(char * serviceName);

    /**
     \brief Get absolute path to account folder

     \param accountId the name of account

     \return Absolute path to folder
    */
    static QString getAccountDir(const QString& accountId);

    /**
      \brief Decode string with XML characters

      \param str Source string with XML characters

      \return Decoded string
      */
    static QString decodeString(const QString& str);

    /**
     \brief Get path to folder of MySocials drivers

     \return Absolute path to folder
    */
    static QString getDriversDir();

    /**
      \brief Recursive remove folder content

      \param aDir Folder which should be removed

      \return True if folder removes successfully; otherwise - false
      */
    static bool RemoveDirectory(QDir &aDir);

    /**
      \brief Remove files in folder corresponded mask of file name

      \param aDir Used folder

      \param filter The string contains a mask of file which should be removed

      \return True if files removes successfully; otherwise - false
      */
    static bool RemoveFiles(QDir &aDir, const QString& filter);

    /**
      \brief Get data directory

      \return The string with path to folder
      */
    static QString getDataDir();

    /**
      \brief Generate unique key for list of comments to image.

      \param photo Selected image.

      \return String contains list of comments key.
      */
    static QString getPhotoCommentListKey(const Photo& photo);

    /**
      \brief Generate unique key for Friend instance.

      \param accountId The ID of corresponded account.

      \param ownerId Th friend ID.

      \return String contains Friend instance key.
      */
    static QString getFriendKey(const QString& accountId, const QString& ownerId);

    /**
      \brief Set settings object
      \param settings Settings object
      */
    static void setSettings(QSettings* settings);
};

#endif // UTILS_H
