#include "utils.h"

#include <QSettings>
#include "servicemgr.h"

Utils::Utils()
{
}

QString Utils::getHomeDir()
{
    QDir dir;
#ifdef HOMEDIR
    QString home(HOMEDIR);
#else
    QString home = dir.homePath() + QString(LOCALDATADIR);
#endif

    return home + QString("/");
}

QString Utils::getFriendsIconDir(char *serviceName)
{
    return Utils::getFriendsIconDir(QString::fromUtf8(serviceName, -1));
}

QString Utils::getFriendsIconDir(const QString& serviceName)
{
    QString icon = Utils::getHomeDir() + QString(FRIEND_ICONS_DIR) + QString("/") + serviceName + QString("/");

    return icon;
}

QString Utils::getAlbumsIconDir(char *serviceName)
{
    return Utils::getAlbumsIconDir(QString::fromUtf8(serviceName, -1));
}

QString Utils::getAlbumsIconDir(const QString& serviceName)
{
    QString icon = Utils::getHomeDir() + QString(ALBUM_ICONS_DIR) + QString("/") + serviceName + QString("/");

    return icon;
}

QString Utils::getPhotoDir(char *serviceName)
{
    return Utils::getPhotoDir(QString::fromUtf8(serviceName, -1));
}

QString Utils::getPhotoDir(const QString& serviceName)
{
    QString baseDir = settings->value(SETTINGS_ALBUM_DIRECTORY).toString();
    if (baseDir.isEmpty())
        baseDir = QDesktopServices::storageLocation(QDesktopServices::PicturesLocation);

    QString path = baseDir + QString("/") + serviceName + QString("/");
    return path;
}

QString Utils::decodeString(const QString& str)
{
    QDomDocument doc;
    doc.setContent(QString("<string>") + str + QString("</string>"));
    doc.normalize();
    QString ret = doc.documentElement().firstChild().toText().nodeValue();
    return ret;
}

QString Utils::getAccountDir(const QString& accountId)
{
    return Utils::getHomeDir() + QString("/accounts/") + accountId + QString("/");
}

QString Utils::getDriversDir()
{
    QString path = Utils::getDataDir();

    return path + QString(DRIVER_LIBRARY_DIR);
}

QString Utils::getDataDir()
{
    QString path;

#ifdef DATAPREFIX
    path = QString(DATAPREFIX);
#else
    path = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
#endif

    return path;
}

bool Utils::RemoveDirectory(QDir &aDir)
{
    bool has_err = false;    
    if (aDir.exists()) { //QDir::NoDotAndDotDot
        QFileInfoList entries = aDir.entryInfoList(QDir::NoDotAndDotDot |
                                                   QDir::Dirs | QDir::Files);
        int count = entries.size();
        for (int idx = 0; ((idx < count) && (false == has_err)); idx++) {
            QFileInfo entryInfo = entries[idx];
            QString path = entryInfo.absoluteFilePath();
            if (entryInfo.isDir()) {
                QDir dir(path);
                has_err = RemoveDirectory(dir);
            } else {
                QFile file(path);
                if (!file.remove())
                    has_err = true;
            }
        }
        if (!aDir.rmdir(aDir.absolutePath()))
            has_err = true;
    }
    return(has_err);
}

bool Utils::RemoveFiles(QDir &aDir, const QString& filter)
{
    bool has_err = false;
    aDir.setNameFilters(QStringList(filter));
    if (aDir.exists()) {
        QFileInfoList entries = aDir.entryInfoList(QDir::NoDotAndDotDot |
                                                   QDir::Dirs | QDir::Files);
        int count = entries.size();
        for (int idx = 0; ((idx < count) && (false == has_err)); idx++) {
            QFileInfo entryInfo = entries[idx];
            QString path = entryInfo.absoluteFilePath();
            if (entryInfo.isDir()) {
                QDir dir(path);
                has_err = RemoveFiles(dir, filter);
            } else {
                QFile file(path);
                if (!file.remove())
                    has_err = true;
            }
        }
    }
    return(has_err);
}

QString Utils::getPhotoCommentListKey(const Photo& photo)
{
    return QString("comments_%1_%2").arg(photo.accountId()).arg(photo.photoId());
}

QString Utils::getFriendKey(const QString& accountId, const QString& ownerId)
{
    return QString("friend_%1_%2").arg(accountId).arg(ownerId);
}

QSettings* Utils::settings = 0;
void Utils::setSettings(QSettings *settings_)
{
    settings = settings_;
}
