#include "qcommentwidget.h"
#include <QTextBlock>
#include <QStyle>

QCommentWidget::QCommentWidget(QFont textFont, QWidget *parent) :
    QWidget(parent)
{
    setupUi(textFont);
}

QCommentWidget::~QCommentWidget()
{
}

void QCommentWidget::setupUi(QFont textFont)
{
    QHBoxLayout *hlayout = new QHBoxLayout(this);
    hlayout->setSpacing(0);
    hlayout->setContentsMargins(1,1,1,1);
    this->setLayout(hlayout);

    this->icon = new QLabel(this);
    this->icon->setBaseSize(ICON_SIZE, ICON_SIZE);
    this->icon->setMinimumSize(ICON_SIZE, ICON_SIZE);
    this->icon->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Minimum));
    this->icon->setAlignment(Qt::AlignCenter);
    hlayout->addWidget(this->icon, 0, Qt::AlignTop);

    QVBoxLayout *vlayout = new QVBoxLayout();
    vlayout->setSpacing(0);
    vlayout->setContentsMargins(5, 1, 0, 1);
    hlayout->addLayout(vlayout, 0);

    QHBoxLayout *topLayout = new QHBoxLayout();
    topLayout->setContentsMargins(0,0,0,0);
    this->date = new QLabel(this);
    this->date->setFont(textFont);
    this->date->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    this->date->setMaximumHeight(17);
    this->name = new QLabel(this);
    this->name->setFont(textFont);
    this->name->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    topLayout->addWidget(this->date);
    topLayout->addWidget(this->name);

    vlayout->addLayout(topLayout, 0);

    this->text = new QTextBrowser();
    this->text->setFont(textFont);
    //this->text->setFocusPolicy(Qt::NoFocus);
    //this->text->setReadOnly(true);
    //this->text->setLineWrapMode(QTextBrowser::WidgetWidth);
    //this->text->setLineWrapColumnOrWidth(0);
    this->text->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    this->text->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    this->text->setMinimumHeight(30);
    //this->text->setAlignment(Qt::AlignVCenter);
    //this->text->setStyleSheet("QTextBrowser {vertical-align: middle; }");
    //overflow: hidden; spaceing: 0; border-radius: 5px;  line-height: 0.5;
    this->text->document()->setTextWidth(this->width() - ICON_SIZE);
    this->text->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
    //this->text->setMinimumHeight(this->text->height());
    vlayout->addWidget(this->text);
    this->text->show();

    this->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
}

void QCommentWidget::setPhotoComment(PhotoComment comment)
{
    this->pComment = comment;
    this->setName();
    this->date->setText(this->pComment.time);
    this->date->adjustSize();
    this->text->setPlainText(this->pComment.text);
    qDebug() << text->toHtml();

    this->updateIcon();
    this->updateGeometry();
    this->update();
}

PhotoComment QCommentWidget::photoComment()
{
    return this->pComment;
}

void QCommentWidget::setSenderProfile(Friend fr)
{
    this->senderProfile = fr;
    this->setName();
    this->updateIcon();

    this->updateGeometry();
    this->update();
}

void QCommentWidget::setName()
{
    QString profName = this->senderProfile.name();
    if (!profName.isEmpty())
        this->name->setText(profName);
    else
        this->name->setText(this->pComment.senderName);
    this->name->adjustSize();
}

void QCommentWidget::updateIcon()
{
    if (!this->senderProfile.icon().isEmpty()) {
        QPixmap pixmap = QPixmap(this->senderProfile.icon());

        if (pixmap.width() > pixmap.height())
            pixmap = pixmap.copy((pixmap.width() - pixmap.height()) / 2, 0, pixmap.height(), pixmap.height());

        if (pixmap.height() > pixmap.width())
            pixmap = pixmap.copy(0, (pixmap.height() - pixmap.width()) / 2, pixmap.width(), pixmap.width());

        pixmap = pixmap.scaled(QSize(ICON_SIZE, ICON_SIZE), Qt::KeepAspectRatio, Qt::SmoothTransformation);
        this->icon->setPixmap(pixmap);
    }

    if (this->icon->pixmap() == NULL || this->icon->pixmap()->isNull())
        this->icon->setPixmap(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")).pixmap(ICON_SIZE));
    this->icon->adjustSize();
}

QDateTime QCommentWidget::dateTime()
{
    return QDateTime::fromString(this->pComment.time, DATE_TIME_FORMAT);
}

void QCommentWidget::setWidth(int width)
{
  this->resize(width, this->heightForWidth(width));

//    int commentWidth = width - this->icon->width();
//    this->text->document()->setTextWidth(commentWidth);

//    this->setMaximumHeight(this->heightForWidth(width));
//    this->setBaseSize(width, this->heightForWidth(width));
    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): " << this->size();
    this->updateGeometry();
}

QSize QCommentWidget::sizeHint() const
{
    int w = this->width();
//    qreal commWidth = this->text->document()->size().width();
//    if (this->icon->size().width() + commWidth > w)
//        w = this->icon->pixmap()->size().width() + commWidth;

    QSize ret( w, heightForWidth(w));
    //qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): " << ret;
    return ret;
}

int QCommentWidget::heightForWidth(int width) const
{
    int ret = this->minimumHeight();

    // icon size
    QSize iconSize = this->icon->pixmap()->size();

    if (iconSize.height() < ICON_SIZE)
        iconSize.setHeight(ICON_SIZE);
    if (iconSize.width() < ICON_SIZE)
        iconSize.setWidth(ICON_SIZE);

    if (iconSize.height() > ret)
        ret = iconSize.height();

    // comment size
    QTextDocument *doc = this->text->document()->clone();
    //doc->setPlainText(this->pComment.text);
    //qreal oldWidth = doc->textWidth();
    doc->setTextWidth(width - iconSize.width() - this->layout()->margin() * 4);
    //doc->adjustSize();
    QSize commentSize = doc->size().toSize();
    //QSize commentSize;

    QTextCursor cur = doc->rootFrame()->firstCursorPosition(); //this->text->textCursor();
    cur.movePosition( QTextCursor::Start );

    bool isNotDone = true;
    int lineCounter = 0;

    while( isNotDone ) {
        isNotDone = cur.movePosition( QTextCursor::Down );
        lineCounter++;
    }

    //int y = doc->rootFrame()->lastCursorPosition().verticalMovementX() - doc->rootFrame()->firstCursorPosition().verticalMovementX();
    //int lines = doc->lineCount();
    int blocks = doc->blockCount();
    //commentSize.setHeight((doc->lineCount() + 1) * QFontMetrics(doc->defaultFont()).height());
    commentSize.setHeight((lineCounter + 1) * QFontMetrics(this->font()).height());
    //commentSize.setHeight(y);
    //qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): comment size=" << this->text->document()->size();
    //doc->setTextWidth(oldWidth);
    delete doc;

//    if (commentSize.height() < this->text->minimumHeight())
//    {
//        commentSize = this->text->size();
//        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): comment=" << commentSize;
//    }
    if (commentSize.height() + this->date->height() > ret)
        ret = commentSize.height() + this->date->height();

    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): preferred size=" << width << ret << "comments=" << commentSize << "date=" << this->date->size() << "icon=" << iconSize << "lines=" << lineCounter << "x" << QFontMetrics(this->font()).height() << "blocks=" << blocks;
    return ret + this->layout()->margin() * 8;
}
