#include "qmessagedelegate.h"

#include <QPainter>
#include <QDebug>
#include <QListView>
#include <datatypes/message.h>

#ifdef Q_WS_MAEMO_5
    #define ITEM_HEIGHT 36
#else
    #define ITEM_HEIGHT 14
#endif

QMessageDelegate::QMessageDelegate(ServiceMgr *sm, QObject *parent) :
    QStyledItemDelegate(parent)
{
    this->sm = sm;
    connect(this->sm, SIGNAL(updateAccounts(QString,AccountList)),
            this, SLOT(updateAccountList(QString,AccountList)));
}

void QMessageDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    Message msg = index.data(Qt::UserRole).value<Message>();

    QRect r = option.rect.adjusted(2, 2, -2, -2);

    if (index.row() % 2 == 0)
        painter->fillRect(option.rect, option.palette.background());
    else
        painter->fillRect(option.rect, option.palette.alternateBase());

    if (option.state & QStyle::State_Selected)
        painter->fillRect(option.rect, option.palette.highlight());

    // highlight new messages
    if (msg.status.toInt() == 0) {
        QFont f = option.font;
        f.setBold(true);
        painter->setFont(f);
    } else {
        painter->setFont(option.font);
    }

    int lines;
#ifdef Q_WS_MAEMO_5
    lines = 2;
#else
    lines = 1;
#endif

    float topPoint = (r.height() - lines * option.fontMetrics.height()) / 2 + r.top();

    switch (index.column()) {
        case 0: {
            int w = option.fontMetrics.width(msg.subject());

#ifdef Q_WS_MAEMO_5
            QDateTime dt = QDateTime::fromString(msg.time, "dd.MM.yyyy hh:mm:ss");
            QString time = dt.toString("dd.MM hh:mm");

            QString author;
            foreach (const Recepient& recepient, msg.recepientList)
                if (mLocalAccountIds.contains(recepient.id))
                    author = msg.senderName;

            if (mLocalAccountIds.contains(msg.senderId))
                author = msg.recepientList.first().name;

            if (author.isEmpty())
                author = msg.senderName;

            time.append(" " + author);

            if (!time.isEmpty()) {
                painter->drawText(r.left(), topPoint, r.width(),
                                  option.fontMetrics.height(),
                                  Qt::AlignVCenter|Qt::AlignLeft,
                                  time);
                topPoint += option.fontMetrics.height();
            }
#endif

            QString subject = msg.subject();
            if (w > r.width()) {
                int charWidth = w / msg.subject().length();
                int symbols = r.width() / charWidth;
                subject.truncate(symbols - 3);
                subject = subject.trimmed();
                subject.append("...");
            }

            painter->drawText(r.left(), topPoint, r.width(),
                              option.fontMetrics.height(),
                              Qt::AlignVCenter|Qt::AlignLeft,
                              subject);

            topPoint += option.fontMetrics.height();

            break;
        }
        case 1: {
            QDateTime dt = QDateTime::fromString(msg.time, "dd.MM.yyyy hh:mm:ss");
            QString time = dt.toString("dd.MM hh:mm");
            painter->drawText(r.left(), topPoint, r.width(),
                          option.fontMetrics.height(),
                          Qt::AlignVCenter|Qt::AlignLeft,
                          time, &r);
            break;
        }
        case 2: {
            QString author;
            foreach (const Recepient& recepient, msg.recepientList)
                if (mLocalAccountIds.contains(recepient.id))
                    author = msg.senderName;

            if (mLocalAccountIds.contains(msg.senderId))
                author = msg.recepientList.first().name;

            if (author.isEmpty())
                author = msg.senderName;

            painter->drawText(r.left(), topPoint, r.width(),
                      option.fontMetrics.height(),
                      Qt::AlignVCenter|Qt::AlignLeft,
                      author, &r);
            break;
        }
        default:
            break;
    }

    topPoint += option.fontMetrics.height();
}

QSize QMessageDelegate::sizeHint ( const QStyleOptionViewItem & option, const QModelIndex & index ) const
{
#ifdef Q_WS_MAEMO_5
    int lines = 2;
#else
    int lines = 1;
#endif

    float rw = float(((QListView*)parent())->viewport()->size().width());

    switch (index.column()) {
        case 0:
            return QSize(rw > 160 ? rw : 160,
                     lines * option.fontMetrics.height() > ITEM_HEIGHT ? lines * option.fontMetrics.height() : ITEM_HEIGHT);
            break;
        case 1:
            return QSize(rw > 40 ? rw : 40,
                     lines * option.fontMetrics.height() > ITEM_HEIGHT ? lines * option.fontMetrics.height() : ITEM_HEIGHT);
            break;
        default:
            break;
    }

    return QSize();
}

void QMessageDelegate::updateAccountList(QString, AccountList list)
{
    mAccountList = list;
    mLocalAccountIds.clear();

    foreach (Account* account, mAccountList) {
        const QString& id = account->getProfile(false).ownerId;
        mLocalAccountIds.insert(id);
    }
}
