#ifndef FILTERPANEL_H
#define FILTERPANEL_H

#include <QWidget>
#include <QVariant>
#include <QMetaType>

class QIcon;
class QToolBar;
class QString;
class QActionGroup;
class DriverInfo;

#ifdef Q_WS_MAEMO_5
#define TOOLBAR_ICON_SIZE 26
#else
#define TOOLBAR_ICON_SIZE 32
#endif

struct FilteredService
{
    QAction* action;
    DriverInfo* driverInfo;
    int index;
};
Q_DECLARE_METATYPE(FilteredService)

class FilterPanel : public QWidget
{
    Q_OBJECT

    QToolBar* mToolbar;
    QActionGroup* mActionGroup;
    int mLastIndex;
    int mCurrentIndex;

    void createToolbar();

public:
    explicit FilterPanel(QWidget *parent = 0);

    void addItem(QAction* action, DriverInfo* driver, bool checked = false);
    QList<QAction*> getServiceActions();

signals:
    void itemSelected(DriverInfo* driverInfo, int index);

private slots:
    void serviceSelected(QAction* act);

public slots:
    void addItem(const QIcon& icon, DriverInfo* driver, bool checked = false);
    void addItem(const QString& string, DriverInfo* driver, bool checked = false);
    void clear();
    void checkItem(DriverInfo*, int index);
};

#endif // FILTERPANEL_H
