#ifndef IMAGEBROWSERPANEL_H
#define IMAGEBROWSERPANEL_H

#include <QWidget>
#include <QPushButton>
#include <QListWidget>
#include <QMessageBox>
#include <QRadioButton>
#include <QString>

#include "widgets/qimageviewer.h"
#include "widgets/qtoppanel.h"
#include "widgets/friends/qfriendlistwidget.h"
#include "utils/hintedit.h"

#include "datatypes/friend.h"
#include "datatypes/album.h"
#include "datatypes/photo.h"

#include "servicemgr.h"

namespace Ui {
    class ImageBrowserPanel;
}

class AlbumInfoWidget;
class ProfileBrowser;
class ImageBrowserPanel : public QWidget
{
    Q_OBJECT

public:
    explicit ImageBrowserPanel(QFont usedFont, QWidget *parent = 0);
    explicit ImageBrowserPanel(QFont usedFont, ServiceMgr *mgr, QWidget *parent = 0);
    ~ImageBrowserPanel();

    void init();

    void hideAll(QLayout *layout);
    void showAll(QLayout *layout);
    void setAlbumsVisible(const bool isShow);
    void setImagesVisible(const bool isShow);
    void setFriendsVisible(const bool isShow);

    void clearEditOwnr();

    // window state for 2 panel mode. First panel is current, Last panel is previous
    enum WindowState {
        WindowFriendAlbum,
        WindowAlbumPhoto,
        WindowPhotoAlbum,
        WindowAlbumFriend
    };

    void showFriendAlbums(Friend fd);

    // update window corresponding current state
    void setState(WindowState state);
    void setState();

private:
    void setAlbumHeader();
    void setAlbumHeader(const Friend& fr);
    void setPhotoHeader();
    void setPhotoHeader(Album al);
    static QString albumItem(const Album& al);
    static QPixmap albumIcon(const Album& al);
    QPixmap photoIcon(const Photo& al);
    static QPixmap photoIcon(const QAttachment& al);


private:
    Ui::ImageBrowserPanel *ui;
    QFriendListWidget *friendsPanel;
    QTopPanel *albumsTopPanel;
    QTopPanel *photosTopPanel;

    QFont usedFont;

    QPushButton *buttonRefreshFriends;
    QRadioButton *peopleradb;
    QRadioButton *newsradb;
    //QPushButton *buttonRefreshAlbums;
    //QPushButton *buttonRefreshPhotos;
    //QPushButton *buttonCloseAlbums;
    //QPushButton *buttonClosePhotos;

    AlbumInfoWidget* albumInfoWidget;
    ProfileBrowser* profileInfoWidget;

    ServiceMgr *sm;

    bool isFriendsUpdate;
    bool isAlbumsUpdate;
    bool isPhotosUpdate;
    bool isFeedUpdate;

    bool isPhotosWidthSet;
    int photosWidth;

    // current state for window
    WindowState state;
    bool isPortraitMode;

    void ownrSelected(Friend fr, bool isNeedUpdateState);

    QListWidgetItem *createFriendWidget(Friend fr);
    void addMeToFriends();

    QString cutHeader(QString text);

signals:
    void openImage(Photo photo);
    void showFriendInfo(Friend fr);
    void showAlbumInfo(Album al);

private slots:
    void ownrSelected(Friend item);
    void albmSelected(QListWidgetItem *item);
    void photoSelected(QListWidgetItem *item);
    void feedEventSelected(QListWidgetItem *item);

    void albumHeaderClicked();
    void photoHeaderClicked();

    void showFriendPanel(bool isShow);

    void refreshFriends();
    void refreshFriends(bool isNeedUpdate);
    void refreshAlbums();
    void refreshAlbums(bool isNeedUpdate);
    void refreshPhotos();
    void refreshPhotos(bool isNeedUpdate);
    void refreshFeed(bool isNeedUpdate);

    void gotError(QString msg, QTransport::Action action, bool isMajor);

    void showFriendInfo();

    void hidePhotos();
    void hideAlbums();

    void orientationChanged();

    void updateListFriends(FriendList list, bool isLastUpdate);
    void updateListAlbums(Friend fr, AlbumList, bool isLastUpdate);
    void updateListPhotos(QString accountId, QString ownerId, QString albumId, PhotoList, bool isLastUpdate);
    void updateFeed(QEventFeedList list, QEventFeed::FeedType type, bool isLastUpdate);

    void updateAccounts(QString accountId, AccountList list);
};

#endif // IMAGEBROWSERPANEL_H
