#ifndef SERVICEFILTER_H
#define SERVICEFILTER_H

#include <QObject>
#include <QVariant>
#include <QSet>

#include "servicemgr.h"
#include "widgets/filter/filterpanel.h"

class ServiceMgr;
class ServiceFilterWidget;
class DriverInfo;
class QWidget;
class QToolBar;
class QActionGroup;

class ServiceFilter : public QObject
{
    Q_OBJECT
    ServiceMgr* mServiceManager;

    mutable QSet<QString> mCacheServiceNames;
    bool isServiceActive(const DriverInfo* driver) const;
    void fillPanel();

public:
    explicit ServiceFilter(ServiceMgr* mgr, QObject *parent = 0);
    QWidget* createWidget();
    void hideWidget(bool hide);

signals:
    void serviceSelected(DriverInfo* driverInfo, int index = -1);
    void itemAdded(const QIcon& icon, DriverInfo* driver, bool checked = 0);
    void itemAdded(const QString& string, DriverInfo* driver, bool checked = 0);
    void reset();

public slots:
    void updateAccounts(QString str, AccountList accountList);

private:
    FilterPanel *filterPanel;
};

#endif // SERVICEFILTER_H
