#include "filtermessagereaded.h"

#include <QActionGroup>
#include <QtDebug>

#include "datatypes/message.h"

FilterMessageReaded::FilterMessageReaded(QObject* parent) :
    Filter(parent), enabled(false)
{
}

int FilterMessageReaded::filterableType() const
{
    return qMetaTypeId<Message>();
}

bool FilterMessageReaded::isFiltered(QVariant value) const
{
    if (enabled)
        return value.value<Message>().isReaded();
    else
        return false;
}

QActionGroup* FilterMessageReaded::createActions()
{
    QActionGroup* actions = new QActionGroup(this);
    actions->setExclusive(false);

    QAction* onlyNewAction = new QAction(tr("New"), actions);
    onlyNewAction->setIcon(QIcon(":/res/msg_listnew.png"));
    onlyNewAction->setCheckable(true);

    connect(onlyNewAction, SIGNAL(toggled(bool)), SLOT(actionToggled(bool)));

    return actions;
}

void FilterMessageReaded::actionToggled(bool state)
{
    enabled = state;
    emitStateChanged();
}
