#include "filter/filtermanager.h"

FilterManager::FilterManager(QObject *parent) :
    QObject(parent)
{
}

void FilterManager::registerFilterableType(int type)
{
    if (isTypeRegistered(type)) {
        qWarning() << "Type " << QMetaType::typeName(type) << " has already been registered";
        return;
    }
    m_types.append(type);
}

void FilterManager::addFilter(Filter *filter)
{
    int type = filter->filterableType();

    if (!isTypeRegistered(type))
        registerFilterableType(type);

    connect(filter, SIGNAL(stateChanged(int)), SIGNAL(stateChanged(int)));
    m_filters[type].append(filter);
}

bool FilterManager::isTypeRegistered(int type) const
{
    return !m_types.empty() && m_types.contains(type);
}
