#include "message.h"

#include <QRegExp>

#define SUBJECT_LENGTH 30
#define DEFAULT_SUBJECT "..."

Message::Message() :
    QObject(0)
{
}

Message::Message(const Message &src)
    : QObject(src.parent())
{
    Message::copyData(this, &src);
}

Message::~Message() {

}

void Message::copyData(Message *dst, const Message *src)
{
    dst->messageId = src->messageId;
    dst->accountId = src->accountId;
    dst->threadId = src->threadId;
    dst->senderId = src->senderId;
    dst->senderName = src->senderName;
    dst->status = src->status;
    dst->text = src->text;
    dst->time = src->time;
    dst->title = src->title;
    dst->recepientList = src->recepientList;
}

Message Message::fromQDomElement(QDomElement fr, QString accountId)
{
    Message ret = Message();

    ret.accountId = accountId;

    if (fr.elementsByTagName(NODE_MESSAGE_ID).count() > 0)
        ret.messageId = fr.elementsByTagName(NODE_MESSAGE_ID).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_THREAD_ID).count() > 0)
        ret.threadId = fr.elementsByTagName(NODE_MESSAGE_THREAD_ID).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_SENDER_ID).count() > 0)
        ret.senderId = fr.elementsByTagName(NODE_MESSAGE_SENDER_ID).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_SENDER_NAME).count() > 0)
        ret.senderName = fr.elementsByTagName(NODE_MESSAGE_SENDER_NAME).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_TEXT).count() > 0)
        ret.text = fr.elementsByTagName(NODE_MESSAGE_TEXT).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_TIME).count() > 0)
        ret.time = fr.elementsByTagName(NODE_MESSAGE_TIME).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_TITLE).count() > 0)
        ret.title = fr.elementsByTagName(NODE_MESSAGE_TITLE).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_MESSAGE_STATUS).count() > 0)
        ret.status = fr.elementsByTagName(NODE_MESSAGE_STATUS).at(0).firstChild().toText().data();

    if (fr.elementsByTagName(NODE_ARRAY).count() > 0)
    {
        QDomNode recepientListNode = fr.elementsByTagName(NODE_ARRAY).at(0);
        int recQuantity = recepientListNode.toElement().attribute("quantity").toInt();
        for (int i = 0; i < recQuantity; i++) {
            Recepient rec;
            QDomElement recNode = recepientListNode.childNodes().at(i).toElement();

            if (recNode.elementsByTagName(NODE_MESSAGE_RECEPIENT_ID).count() > 0)
                rec.id = recNode.elementsByTagName(NODE_MESSAGE_RECEPIENT_ID).at(0).firstChild().toText().data();
            if (recNode.elementsByTagName(NODE_MESSAGE_RECEPIENT_NAME).count() > 0)
                rec.name = recNode.elementsByTagName(NODE_MESSAGE_RECEPIENT_NAME).at(0).firstChild().toText().data();

            ret.recepientList.append(rec);
        }
    }
    return ret;
}

QDomElement Message::toQDomElement(QDomDocument doc)
{
    return Message::toQDomElement(doc, *this);
}

QDomElement Message::toQDomElement(QDomDocument doc, Message src)
{
    QDomElement ret = doc.createElement(NODE_MESSAGE_ROOT);

    // ID
    if (!src.messageId.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_ID);
        QDomText t = doc.createTextNode(src.messageId);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // thread id
    if (!src.threadId.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_THREAD_ID);
        QDomText t = doc.createTextNode(src.threadId);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // sender id
    if (!src.senderId.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_SENDER_ID);
        QDomText t = doc.createTextNode(src.senderId);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // sender name
    if (!src.senderName.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_SENDER_NAME);
        QDomText t = doc.createTextNode(src.senderName);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // recepient list
    if (src.recepientList.count() > 0)
    {
        QDomElement node = doc.createElement(NODE_ARRAY);
        node.setAttribute("name", NODE_MESSAGE_RECIPIENT_LIST);
        node.setAttribute("quantity", src.recepientList.count());
        for (int i = 0; i < src.recepientList.count(); i++) {
            QDomNode node2 = doc.createElement(NODE_STRUCT);
            node2.toElement().setAttribute("name", NODE_MESSAGE_RECEPIENT);

            QDomElement idItem = doc.createElement(NODE_MESSAGE_RECEPIENT_ID);
            QDomElement nameItem = doc.createElement(NODE_MESSAGE_RECEPIENT_NAME);

            QDomText t1 = doc.createTextNode(src.recepientList.at(i).id);
            QDomText t2 = doc.createTextNode(src.recepientList.at(i).name);

            idItem.appendChild(t1);
            nameItem.appendChild(t2);
            node.appendChild(node2);
            node2.appendChild(idItem);
            node2.appendChild(nameItem);
        }
        ret.appendChild(node);
    }

    // time
    if (!src.time.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_TIME);
        QDomText t = doc.createTextNode(src.time);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // text
    if (!src.text.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_TEXT);
        QDomText t = doc.createTextNode(src.text);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // title
    if (!src.title.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_TITLE);
        QDomText t = doc.createTextNode(src.title);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // status
    if (!src.status.isEmpty())
    {
        QDomElement node = doc.createElement(NODE_MESSAGE_STATUS);
        QDomText t = doc.createTextNode(src.status);
        ret.appendChild(node);
        node.appendChild(t);
    }

    return ret;
}

const QString Message::subject()
{
    if (this->title.isEmpty() || this->title == DEFAULT_SUBJECT) {
        this->title = subjectFromBody(this->text);
        return this->title;
    } else {
        return this->title;
    }
}

// Choose subject for message as begin of body
QString Message::subjectFromBody(QString messageBody)
{
    messageBody = messageBody.simplified();
    if (messageBody.isEmpty()) {
        return DEFAULT_SUBJECT;
    } else if (messageBody.length() <= SUBJECT_LENGTH) {
        return messageBody;
    } else {
        messageBody.truncate(SUBJECT_LENGTH);
        messageBody.truncate(messageBody.lastIndexOf(QRegExp("\\s")));
        messageBody = messageBody.trimmed();
        messageBody.append(DEFAULT_SUBJECT);
        return messageBody;
    }
}

Message& Message::operator =(Message const &src)
{
    Message::copyData(this, &src);
    return *this;
}

bool Message::isReaded() const
{
    return status.startsWith('1');
}
