#ifndef UIHELP_H
#define UIHELP_H

#include <QMainWindow>
#include <QDebug>

#include "utils/utils.h"

namespace Ui {
    class uihelp;
}

/**
  \brief The webkit based widget for display any HTML documents

  The uihelp widget shows any HTML documents, for example help or about, in separate window. It based on webkit.
  */
class uihelp : public QMainWindow
{
    Q_OBJECT

public:
    /**
      \brief The constructor.

      \param path Path to HTML file which should be shown.

      \param title Window title

      \param fnt Used font

      \param parent The parent widget
      */
    explicit uihelp(QString path, QString title, QFont fnt, QWidget *parent = 0);

    /**
      \brief A destructor
      */
    ~uihelp();

protected:
    /**
      \brief Slot for changeEvent

      This slot responds to language change

      \param e Event data
      */
    void changeEvent(QEvent *e);

private:
    Ui::uihelp *ui;
};

#endif // UIHELP_H
