#include "qtoppanel.h"

#include <QVBoxLayout>

QTopPanel::QTopPanel(QWidget *parent) :
    QWidget(parent), back(0), refresh(0), icon(0), text(0), infoWidget()
{
    QVBoxLayout *mainLayout = new QVBoxLayout();
    this->setLayout(mainLayout);

    QHBoxLayout *layout = new QHBoxLayout();
    mainLayout->addLayout(layout);

    this->back = new QPushButton(this);
    this->back->setFlat(true);
    layout->addWidget(this->back);
    this->icon = new QLabel(this);
    layout->addWidget(this->icon);
    this->text = new QLabel(this);
    layout->addWidget(this->text);
    this->refresh = new QPushButton(this);
    this->refresh->setFlat(true);
    layout->addWidget(this->refresh);

    // connect signals
    connect(this->back, SIGNAL(clicked()), this, SIGNAL(backPressed()));
    connect(this->refresh, SIGNAL(clicked()), this, SIGNAL(refreshPressed()));
    connect(this, SIGNAL(clicked()), SLOT(toggleInfoWidget()));
}

QTopPanel::~QTopPanel()
{
}

void QTopPanel::setPixmap(QPixmap icon)
{
    this->icon->setPixmap(icon);
}

void QTopPanel::setText(QString text)
{
    this->text->setText(text);
}

void QTopPanel::setBackIcon(QIcon icon)
{
    this->back->setIcon(icon);
}

void QTopPanel::setRefreshIcon(QIcon icon)
{
    this->refresh->setIcon(icon);
}

void QTopPanel::setInfoWidget(QWidget *infoWidget_)
{
    if (this->infoWidget != 0)
        return;

    this->infoWidget = infoWidget_;
    this->hideInfoWidget();
    this->layout()->addWidget(infoWidget);
}

void QTopPanel::setBackVisible(bool visible)
{
    this->back->setVisible(visible);
}

void QTopPanel::mousePressEvent(QMouseEvent * event)
{
    event->accept();
    if (event->button() == Qt::LeftButton)
        emit this->clicked();
}

void QTopPanel::hideInfoWidget()
{
    if (this->infoWidget != 0)
        this->infoWidget->hide();
}

void QTopPanel::showInfoWidget()
{
    if (this->infoWidget != 0)
        this->infoWidget->show();
}

void QTopPanel::toggleInfoWidget()
{
    if (this->infoWidget != 0)
        this->infoWidget->setVisible(!this->infoWidget->isVisible());
}
