#include "profilebrowser.h"
#include "ui_profilebrowser.h"

#include "datatypes/driverinfo.h"
#include <QSizeGrip>

ProfileBrowser::ProfileBrowser(ServiceMgr *smr, bool showAvatar_, QWidget *parent) :
    QWidget(parent),
    sm(smr),
    ui(new Ui::ProfileBrowser),
    showAvatar(showAvatar_)
{
    ui->setupUi(this);
    init();

    connect(ui->listProfiles, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(profileSelected(QListWidgetItem*)));
}

ProfileBrowser::ProfileBrowser(ServiceMgr *smr, Friend profile, bool showAvatar_, QWidget *parent) :
    QWidget(parent),
    sm(smr),
    ui(new Ui::ProfileBrowser),
    showAvatar(showAvatar_)
{
    ui->setupUi(this);
    init();

    this->setProfile(profile);
}

ProfileBrowser::~ProfileBrowser()
{
    delete ui;
}

void ProfileBrowser::init()
{
    if (showAvatar) {
        ui->photoLabel->setMinimumWidth(100);
        this->ui->photoLabel->setPixmap(QIcon(":/res/general_default_avatar.png").pixmap(100));
    } else {
       ui->photoLabel->hide();
       ui->listProfiles->hide();
       //this->ui->scrollArea->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);
    }
    this->ui->scrollArea->setWidgetResizable(true);
    QSizeGrip *gr=new QSizeGrip(this->ui->listProfiles); //to resize the widget
}

void ProfileBrowser::setProfile(Friend profile)
{
    this->showProfile(profile);
    this->currentProfile = profile;
    if (showAvatar)
    {
        FriendList list = profile.getProfileList();

        if (list.length() > 0)
        {
            qDebug() << __FILE__ << __LINE__ << __FUNCTION__ << "show " << list.length() + 1 << " profiles";

            this->ui->listProfiles->clear();

            foreach (DriverInfo* driver, sm->getDrivers()) {
                if (!driver->icon.isNull()) {
                    qDebug() << "compare driver=" << driver->serviceName << " and account=" << profile.serviceId;
                    if (driver->serviceName == profile.serviceId)
                    {
                        QListWidgetItem *itm = new QListWidgetItem(profile.name() + " (" + driver->name + ")", this->ui->listProfiles);
                        itm->setIcon(driver->icon);
                        QVariant v;
                        v.setValue(profile);
                        itm->setData(Qt::UserRole, v);
                        break;
                        break;
                    }
                }
            }

            for (int i = 0; i < list.length(); i++)
            {
                foreach (DriverInfo* driver, sm->getDrivers()) {
                    if (!driver->icon.isNull()) {
                        qDebug() << "compare driver=" << driver->serviceName << " and account=" << list.at(i).serviceId;
                        if (driver->serviceName.compare(list.at(i).serviceId) == 0)
                        {
                            QListWidgetItem *itm = new QListWidgetItem(list.at(i).name() + " (" + driver->name + ")", this->ui->listProfiles);
                            itm->setIcon(driver->icon);
                            QVariant v;
                            v.setValue(list.at(i));
                            itm->setData(Qt::UserRole, v);
                            break;
                        }
                    }
                }

            }
            this->ui->listProfiles->show();
        } else {
            this->ui->listProfiles->hide();
        }
    }
}

void ProfileBrowser::showProfile(Friend profile)
{
    QString name = "<h2>" + profile.name() + "</h2>";

    ui->nameLabel->setText(name);

    QString desc;

    if (!profile.birthday().isEmpty() || !profile.gender().isEmpty())
        desc.append("<h3>" + tr("General") + "</h3>");

    if (!profile.nickName().isEmpty() && profile.nickName().compare(profile.name()) != 0)
        desc.append("<b>" + tr("Nickname: ") + "</b>" + profile.nickName() + "<br>");

    if (!profile.birthday().isEmpty())
        desc.append("<b>" + tr("Birthday: ") + "</b>" + profile.birthday() + "<br>");

    if (!profile.gender().isEmpty())
    {
        desc.append("<b>" + tr("Gender: ") + "</b>" + tr(profile.gender().toAscii()));
    }

    if ((!profile.city().isEmpty() || !profile.country().isEmpty()))
    {
        desc.append("<h3>" + tr("Place") + "</h3>");
    }

    if (!profile.city().isEmpty())
        desc.append(profile.city());

    if (!profile.country().isEmpty())
    {
        if (!profile.city().isEmpty())
            desc.append(", ");
        desc.append(profile.country());
    }

    if (!profile.mobilePhone().isEmpty() || !profile.homePhone().isEmpty())
    {
        desc.append("<h3>" + tr("Contacts") + "</h3>");
    }

    if (!profile.mobilePhone().isEmpty())
    {
        desc.append(profile.mobilePhone());
    }

    if (!profile.homePhone().isEmpty())
    {
        if (!profile.mobilePhone().isEmpty())
            desc.append("<br>");
        desc.append(profile.homePhone());
    }

    ui->descLabel->setText(desc);

    if (showAvatar)
    {
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": icon=" << profile.icon();
        if (profile.icon().isEmpty())
            this->ui->photoLabel->setPixmap(QIcon(":/res/general_default_avatar.png").pixmap(100));
        else
        {
            QIcon icn(profile.icon());
            if (icn.isNull())
                this->ui->photoLabel->setPixmap(QIcon(":/res/general_default_avatar.png").pixmap(100));
            else
                this->ui->photoLabel->setPixmap(icn.pixmap(100));
        }
    }

}

void ProfileBrowser::profileSelected(QListWidgetItem *item)
{
    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Friend>()) {
        Friend fd = v.value<Friend>();
        this->showProfile(fd);
    }
}
