#include "qfriendlistwidget.h"
#include "ui_qfriendlistwidget.h"

#include <QToolBar>

#include "qfrienddelegate.h"
#include "filter/servicefilter.h"

QFriendListWidget::QFriendListWidget(QFont fnt, ServiceMgr *sm, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::QFriendListWidget), sm(sm), isMeSelected(true)
{
    // set up search buttons
    ui->setupUi(this);
    ui->layoutFriendsBottom->addWidget(editOwnr = new HintEdit(this));
    ui->layoutFriendsBottom->addWidget(buttonEditOwnr = new QPushButton(this));

    buttonEditOwnr->setIcon(QIcon::fromTheme("general_backspace",
                                              QIcon(":/res/general_backspace.png")));
    buttonEditOwnr->setFlat(TRUE);
    editOwnr->setHintText(tr("Type a name..."));

    connect(editOwnr, SIGNAL(textChanged(QString)),
            this, SLOT(editOwnr_textChanged(QString)));
    connect(buttonEditOwnr, SIGNAL(clicked()),
            this, SLOT(buttonResetOwnr_clicked()));

    // set up list view
    ui->listView->setItemDelegate(new QFriendDelegate(ui->listView));
    ui->listView->setFont(fnt);

    // prepare model
    model = new QFriendListModel(this);
    connect(sm, SIGNAL(updateFriends(FriendList,bool)), model, SLOT(updateList(FriendList)));
    ui->listView->setModel(model);

    //model->updateList(sm->getFriends(false, false));

#ifdef Q_WS_MAEMO_5
    connect(ui->listView,
            SIGNAL(clicked(QModelIndex)),
            this,
            SLOT(itemSelected(QModelIndex)));
#else
    // it allows navigation by arrow keys
    connect(ui->listView->selectionModel(),
            SIGNAL(currentChanged(QModelIndex,QModelIndex)),
            this,
            SLOT(itemSelected(QModelIndex)));
#endif

    //context filters
    QToolBar *imageFilters = new QToolBar;
    imageFilters->setOrientation(Qt::Vertical);
    imageFilters->setIconSize(QSize(TOOLBAR_ICON_SIZE, TOOLBAR_ICON_SIZE));

    QAction *meButton = imageFilters->addAction(tr("Me"));
#ifndef Q_WS_MAEMO_5
    meButton->setIcon(QIcon(":/res/me.png"));
#else
    meButton->setIcon(QIcon(":/res/me_w.png"));
#endif
    meButton->setData("Me");
    ui->filtersLayout->addWidget(imageFilters);

    //service filters
    ServiceFilter* filter = sm->serviceFilter();
    ui->filtersLayout->addWidget(filter->createWidget());

    // This is toolbar to datatype filters
    filtersToolBar_ = new QToolBar;
    filtersToolBar_->setOrientation(Qt::Vertical);
    filtersToolBar_->setIconSize(QSize(TOOLBAR_ICON_SIZE, TOOLBAR_ICON_SIZE));
    ui->filtersLayout->addWidget(filtersToolBar_);
    ui->filtersLayout->addStretch();

    connect(filter, SIGNAL(serviceSelected(DriverInfo*)), sm, SLOT(changeFilteredService(DriverInfo*)));
    connect(imageFilters, SIGNAL(actionTriggered(QAction*)), this, SLOT(itemSelected(QAction *)));
    connect(this->sm, SIGNAL(updateFriends(FriendList, bool)), this, SLOT(updateFriends(FriendList, bool)));
}

QFriendListWidget::~QFriendListWidget()
{
    delete ui;
}

void QFriendListWidget::itemSelected(QModelIndex in)
{
    Friend selectedFriend = in.data(Qt::UserRole).value<Friend>();

    this->selectedItem = in;
    this->isMeSelected = false;

    // disable reselection of profile
    if (this->selectedFrId.compare(selectedFriend.ownerId) == 0 &&
        this->selectedFrAccount.compare(selectedFriend.accountId) == 0)
    {
        return;
    }

    this->selectedFrAccount = selectedFriend.accountId;
    this->selectedFrId = selectedFriend.ownerId;

    qDebug() << "selected" << selectedFriend.name() << selectedFriend.ownerId;

    emit ownerSelected(selectedFriend);
}

void QFriendListWidget::itemSelected(QAction *act)
{
    if (act->data().toString().compare("Me") == 0)
    {
        this->isMeSelected = true;
        emit ownerSelected(Friend());
    }
}

void QFriendListWidget::editOwnr_textChanged(QString str)
{
    this->model->setNameFilter(str);
}

void QFriendListWidget::buttonResetOwnr_clicked()
{
    editOwnr->clear();
}

Friend QFriendListWidget::getSelectedFriend() const
{
    // try to show me
    if (this->isMeSelected)
        return Friend();

    // if owner was selected
    if (selectedItem.isValid())
        return selectedItem.data(Qt::UserRole).value<Friend>();

    AccountList accs = this->sm->getAccounts();

    if (accs.length() > 0)
    {
        Friend mFr = this->sm->getAccounts().at(0)->getProfile(false);

        return mFr;
    }

    // or empty profile
    return Friend();
}

void QFriendListWidget::selectFriend(const Friend &fr)
{
    if (fr.isEmpty())
    {
        this->isMeSelected = true;
        emit ownerSelected(fr);
    } else {
        QModelIndex idx = this->model->getIndex(fr);
        if (idx.isValid())
        {
            this->ui->listView->setCurrentIndex(idx);
            this->selectedItem = idx;
            this->isMeSelected = false;
            this->selectedFrAccount = fr.accountId;
            this->selectedFrId = fr.ownerId;
            emit ownerSelected(fr);
        }
    }
}

void QFriendListWidget::updateFriends(FriendList, bool)
{
    if (!this->isMeSelected)
    {
        QModelIndex idx = this->model->getIndex(this->selectedFrAccount, this->selectedFrId);
        Friend fr = idx.data(Qt::UserRole).value<Friend>();
        if (idx.isValid() && (fr.accountId == this->selectedFrAccount) && (fr.ownerId == this->selectedFrId))
        {
            this->ui->listView->setCurrentIndex(idx);
            this->selectedItem = idx;
        } else {
            qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << ": can't found selected friend (" << this->selectedFrAccount << this->selectedFrId << ")";
            //this->ui->listView->selectionModel()->setCurrentIndex(model->index(0), QItemSelectionModel::NoUpdate);
            //this->itemSelected(model->index(0));
        }
    }
}

QToolBar* QFriendListWidget::filtersToolBar() const
{
    return filtersToolBar_;
}
