#include "filter/servicefilter.h"

#include <QVariant>

#include "servicemgr.h"
#include "datatypes/driverinfo.h"

ServiceFilter::ServiceFilter(ServiceMgr* mgr, QObject *parent) :
    QObject(parent), mServiceManager(mgr)
{
    connect(mServiceManager, SIGNAL(updateAccounts(QString,AccountList)), SLOT(updateAccounts(QString,AccountList)));
}

QWidget* ServiceFilter::createWidget()
{
    filterPanel = new FilterPanel;

    connect(this, SIGNAL(itemAdded(QIcon,DriverInfo*,bool)), filterPanel, SLOT(addItem(QIcon,DriverInfo*,bool)));
    connect(this, SIGNAL(itemAdded(QString,DriverInfo*,bool)), filterPanel, SLOT(addItem(QString,DriverInfo*,bool)));
    connect(this, SIGNAL(reset()), filterPanel, SLOT(clear()));

    fillPanel();

    connect(filterPanel, SIGNAL(itemSelected(DriverInfo*, int)), SIGNAL(serviceSelected(DriverInfo*, int)));
    connect(this, SIGNAL(serviceSelected(DriverInfo*,int)), filterPanel, SLOT(checkItem(DriverInfo*, int)));

    return filterPanel;
}

bool ServiceFilter::isServiceActive(const DriverInfo* driver) const
{
    if (mCacheServiceNames.empty()) {
        foreach (const Account* account, mServiceManager->getAccounts()) {
            mCacheServiceNames.insert(account->serviceName());
        }
    }

    return mCacheServiceNames.contains(driver->serviceName);
}

void ServiceFilter::updateAccounts(QString, AccountList)
{
    mCacheServiceNames.clear();
    fillPanel();
}

void ServiceFilter::fillPanel()
{
    emit reset();
#ifndef Q_WS_MAEMO_5
    emit itemAdded(QIcon(":/res/no_filter.png"), 0, true);
#else
    emit itemAdded(QIcon(":/res/no_filter_w.png"), 0, true);
#endif

    foreach (DriverInfo* driver, mServiceManager->getDrivers()) {
        if (!isServiceActive(driver)) continue;

        if (!driver->icon.isNull()) {
            emit itemAdded(driver->icon, driver);
        } else {
            emit itemAdded(driver->name, driver);
        }
    }
}

void ServiceFilter::hideWidget(bool hide)
{
    this->filterPanel->setVisible(!hide);
}
