/**
  \file message.h
  \brief Message class description
  \author MySocials team
  \date 2011-03-31
  */
#ifndef MESSAGE_H
#define MESSAGE_H

#include <QObject>
#include <QString>
#include <QMetaType>
#include <QDebug>
#include <QDomDocument>

#include "utils/qrefreshlist.h"

#define NODE_MESSAGE_ROOT "message"
#define NODE_MESSAGE_ID "id"
#define NODE_MESSAGE_THREAD_ID "threadId"
#define NODE_MESSAGE_SENDER_ID "senderId"
#define NODE_MESSAGE_SENDER_NAME "senderName"
#define NODE_MESSAGE_RECEPIENT_ID "recepientId"
#define NODE_MESSAGE_RECEPIENT_NAME "recepientName"
#define NODE_MESSAGE_RECIPIENT_LIST "recepientList"
#define NODE_MESSAGE_RECEPIENT "recepient"
#define NODE_MESSAGE_TEXT "text"
#define NODE_MESSAGE_TIME "time"
#define NODE_MESSAGE_TITLE "title"
#define NODE_MESSAGE_STATUS "status"
#define NODE_ARRAY "array"
#define NODE_STRUCT "struct"

//! Structure for representing of Recepient List
/*!
 \brief

 \class Recepient message.h "src/datatypes/message.h"
*/
struct Recepient {
    QString id; /*!< \brief The ID of recepient */
    QString name; /*!< \brief The name of recepient */
};

/*!
 \brief A class for message information storage.
 */
/*!
 \brief

 \class Message message.h "src/datatypes/message.h"
*/
class Message : public QObject
{
    Q_OBJECT
public:
    /*!
     \brief

     \fn Message
    */
    Message();
    /*!
     \brief

     \fn Message
     \param
    */
    Message(const Message&);
    /*!
     \brief

     \fn ~Message
    */
    ~Message();

    QString messageId; /*!< TODO */
    QString accountId; /*!< TODO */
    QString senderId; /*!< TODO */
    QString senderName; /*!< TODO */
    QString threadId; /*!< TODO */

    QList<Recepient> recepientList; /*!< TODO */

    // message body
    QString text; /*!< TODO */

    // message title
    QString title; /*!< TODO */

    // date
    QString time; /*!< TODO */

    /*!
     \brief

     \fn subject
    */
    const QString subject();
    /*!
     \brief

     \fn subjectFromBody
     \param messageBody
    */
    QString subjectFromBody(QString messageBody);

    QString status; /*!< TODO */

    // store data to XML format
    /*!
     \brief

     \fn toQDomElement
     \param doc
    */
    QDomElement toQDomElement(QDomDocument doc);

    // store data to XML format
    /*!
     \brief

     \fn toQDomElement
     \param doc
     \param src
    */
    static QDomElement toQDomElement(QDomDocument doc, Message src);

    // load message list from XML struct
    /*!
     \brief

     \fn fromQDomElement
     \param fr
     \param accountId
    */
    static Message fromQDomElement(QDomElement fr, QString accountId);

    /*!
     \brief

     \fn operator =
     \param
    */
    Message& operator=(const Message&);
    /*!
     \brief

     \fn copyData
     \param dst
     \param src
    */
    static void copyData(Message *dst, const Message *src);

    /*!
      \brief Check is message readed
      \return true if readed, false otherwise
    */
    bool isReaded() const;

signals:

public slots:

};

/*! \typedef MessageList
 Structure for stacking process of message uploading
 \sa QRefreshList
*/ 
/*!
 \brief

 \typedef MessageList*/
typedef QRefreshList<Message> MessageList;

Q_DECLARE_METATYPE(Message)
Q_DECLARE_METATYPE(MessageList)

#endif // MESSAGE_H
