
#include "friend.h"

Friend::Friend()
    : _online(false), _isMainProfile(true)
{
}

Friend::Friend(const Friend & src)
{
    Friend::copyData(this, &src);
}

Friend::~Friend()
{
}

void Friend::setMobilePhone(const QString& val)
{
    this->_mobilePhone = val;
}

QString Friend::mobilePhone() const
{
    if (!this->_isMainProfile) {
        for (int i = 0; i < this->_profiles.length(); i++)
            if (this->_profiles.at(i)._isMainProfile)
                return this->_profiles.at(i)._mobilePhone;
    }
    return this->_mobilePhone;
}

void Friend::setIcon_url(const QString& val)
{
    this->_icon_url = val;
}

QString Friend::icon_url() const
{
    return this->_icon_url;
}

void Friend::setIcon(const QString& icon)
{
    this->_icon = icon;
}

QString Friend::icon() const
{
    return this->_icon;
}

void Friend::setFirstName(const QString &val)
{
    this->_firstName = val;
}

QString Friend::firstName() const
{
    return this->_firstName;
}

void Friend::setLastName(const QString& val)
{
    this->_lastName = val;
}

QString Friend::lastName() const
{
    return this->_lastName;
}

void Friend::setCity(const QString& val)
{
    this->_city = val;
}

QString Friend::city() const
{
    return this->_city;
}

void Friend::setCountry(const QString& val)
{
    this->_country = val;
}

QString Friend::country() const
{
    return this->_country;
}

void Friend::setHomePhone(const QString& val)
{
    this->_homePhone = val;
}

QString Friend::homePhone() const
{
    return this->_homePhone;
}

void Friend::setBirthday(const QString& val)
{
    this->_birthday = val;
}

QString Friend::birthday() const
{
    return this->_birthday;
}

void Friend::setNickName(const QString& val)
{
    this->_nickName = val;
}

QString Friend::nickName() const
{
    return this->_nickName;
}

void Friend::setGender(const QString& val)
{
    this->_gender = val;
}

QString Friend::gender() const
{
    return this->_gender;
}

void Friend::setOnline(const bool val)
{
    this->_online = val;
}

bool Friend::online() const
{
    return this->_online;
}

QString Friend::name() const
{
    QString ret = tr("Unknown");

    if (this->_firstName.isEmpty() && this->_lastName.isEmpty())
        ret = this->_nickName;
    else
        ret = this->_firstName;

    if (ret.length() > 0 && this->_lastName.length() > 0)
        ret += " ";
    ret += this->_lastName;

    return ret;
}

void Friend::copyData(Friend *dst, const Friend *src)
{
    dst->accountId = src->accountId;
    dst->serviceId = src->serviceId;
    dst->_birthday = src->_birthday;
    dst->_city = src->_city;
    dst->_country = src->_country;
    dst->_firstName = src->_firstName;
    dst->_gender = src->_gender;
    dst->_homePhone = src->_homePhone;
    dst->_icon = src->_icon;
    dst->_icon_url = src->_icon_url;
    dst->ownerId = src->ownerId;
    dst->_lastName = src->_lastName;
    dst->_mobilePhone = src->_mobilePhone;
    dst->_nickName = src->_nickName;
    dst->_online = src->_online;
    dst->_isMainProfile = src->_isMainProfile;
    dst->_profiles = src->_profiles;
}

QDomElement Friend::toQDomElement(QDomDocument& doc, const Friend& src, const bool addOptionalInfo)
{
    QDomElement ret = doc.createElement(NODE_FRIEND_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_FRIEND_ID);
    QDomText t = doc.createTextNode(src.ownerId);
    ret.appendChild(node);
    node.appendChild(t);

    // First Name
    if (!src._firstName.isEmpty())
    {
        node = doc.createElement(NODE_FRIEND_FIRST_NAME);
        t = doc.createTextNode(src._firstName);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // Nick Name
    if (!src._nickName.isEmpty())
    {
        node = doc.createElement(NODE_FRIEND_NICK_NAME);
        t = doc.createTextNode(src._nickName);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // Last Name
    if (!src._lastName.isEmpty())
    {
        node = doc.createElement(NODE_FRIEND_LAST_NAME);
        t = doc.createTextNode(src._lastName);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // avatar
    if (!src._icon.isEmpty())
    {
        node = doc.createElement(NODE_FRIEND_ICON);
        t = doc.createTextNode(src._icon);
        ret.appendChild(node);
        node.appendChild(t);
    }

    // avatar url
    if (!src._icon_url.isEmpty())
    {
        node = doc.createElement(NODE_FRIEND_ICON_URL);
        t = doc.createTextNode(src._icon_url);
        ret.appendChild(node);
        node.appendChild(t);
    }

    if (addOptionalInfo) {
        // gender
        if (!src._gender.isEmpty())
        {
            node = doc.createElement(NODE_FRIEND_GENDER);
            t = doc.createTextNode(src._gender);
            ret.appendChild(node);
            node.appendChild(t);
        }

        // birthday
        if (!src._birthday.isEmpty())
        {
            node = doc.createElement(NODE_FRIEND_BIRTHDAY);
            t = doc.createTextNode(src._birthday);
            ret.appendChild(node);
            node.appendChild(t);
        }

        // mobile phone
        if (!src._mobilePhone.isEmpty())
        {
            node = doc.createElement(NODE_FRIEND_MOBILE_PHONE);
            t = doc.createTextNode(src._mobilePhone);
            ret.appendChild(node);
            node.appendChild(t);
        }

        // home phone
        if (!src._homePhone.isEmpty())
        {
            node = doc.createElement(NODE_FRIEND_HOME_PHONE);
            t = doc.createTextNode(src._homePhone);
            ret.appendChild(node);
            node.appendChild(t);
        }

        // city
        if (!src._city.isEmpty())
        {
            node = doc.createElement(NODE_FRIEND_CITY);
            t = doc.createTextNode(src._city);
            ret.appendChild(node);
            node.appendChild(t);
        }

        // country
        if (!src._country.isEmpty())
        {
            node = doc.createElement(NODE_FRIEND_COUNTRY);
            t = doc.createTextNode(src._country);
            ret.appendChild(node);
            node.appendChild(t);
        }
    }

    return ret;
}

Friend Friend::fromQDomElement(const QDomElement& fr, const QString& accountId, const QString& serviceId)
{
    Friend ret = Friend();

    if (fr.elementsByTagName(NODE_FRIEND_ID).count() > 0)
        ret.ownerId = fr.elementsByTagName(NODE_FRIEND_ID).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_FIRST_NAME).count() > 0)
        ret._firstName = fr.elementsByTagName(NODE_FRIEND_FIRST_NAME).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_NICK_NAME).count() > 0)
        ret._nickName = fr.elementsByTagName(NODE_FRIEND_NICK_NAME).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_LAST_NAME).count() > 0)
        ret._lastName = fr.elementsByTagName(NODE_FRIEND_LAST_NAME).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_ICON).count() > 0)
        ret._icon = fr.elementsByTagName(NODE_FRIEND_ICON).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_ICON_URL).count() > 0)
        ret._icon_url = fr.elementsByTagName(NODE_FRIEND_ICON_URL).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_GENDER).count() > 0)
        ret._gender = fr.elementsByTagName(NODE_FRIEND_GENDER).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_BIRTHDAY).count() > 0)
        ret._birthday = fr.elementsByTagName(NODE_FRIEND_BIRTHDAY).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_MOBILE_PHONE).count() > 0)
        ret._mobilePhone = fr.elementsByTagName(NODE_FRIEND_MOBILE_PHONE).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_HOME_PHONE).count() > 0)
        ret._homePhone = fr.elementsByTagName(NODE_FRIEND_HOME_PHONE).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_CITY).count() > 0)
        ret._city = fr.elementsByTagName(NODE_FRIEND_CITY).at(0).firstChild().toText().data();
    if (fr.elementsByTagName(NODE_FRIEND_COUNTRY).count() > 0)
        ret._country = fr.elementsByTagName(NODE_FRIEND_COUNTRY).at(0).firstChild().toText().data();
    ret.accountId = accountId;
    ret.serviceId = serviceId;

    return ret;
}

AlbumList Friend::getAlbumList() const
{
    AlbumList ret;
    QFile file(Utils::getAccountDir(this->accountId) + QString(FILE_ALBUMS_DATA).arg(this->ownerId));
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    // get list updated time
    QDomElement root = doc.elementsByTagName(NODE_ALBUMS_ROOT).at(0).toElement();
    QDateTime time_create = QDateTime::fromString(root.attribute(ATTR_REFRESH, ""), DATE_TIME_FORMAT);
    ret.setTimeCreate(time_create);

    // parse list of albums
    QDomNodeList lst = doc.elementsByTagName(NODE_ALBUM_ROOT);

    qDebug() << "Start load of " << lst.length() << " albums for " << this->ownerId;
    for (uint i = 0; i < lst.length(); i++) {
        ret.append(Album::fromQDomElement(lst.at(i).toElement(), this->accountId, this->ownerId));
    }

    return ret;

}

void Friend::setAlbumList(const AlbumList& list, const QString& accountId, const QString& friendId)
{
    if (friendId.isEmpty())
        return;

    // store albums into cache
    QDomDocument out("MyDoc");
    QDomElement profile = out.createElement(NODE_ALBUMS_ROOT);
    profile.setAttribute(ATTR_REFRESH, list.timeCreate().toString(DATE_TIME_FORMAT));
    out.appendChild(profile);


    for (int i = 0; i < list.length(); i++) {
        profile.appendChild(list[i].toQDomElement(out));
    }

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + "/" + QString(FILE_ALBUMS_DATA).arg(friendId));
    qDebug() << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();

}

Friend& Friend::operator =(const Friend& src)
{
    Friend::copyData(this, &src);

    return *this;
}

bool Friend::operator <(const Friend& fr1) const
{
    // compare names
    if (this->online() == fr1.online())
        return this->name() < fr1.name();

    // if this is online then prefer
    if (this->online())
        return true;

    // fr1 is online, prefer
    return false;
}

bool Friend::operator ==(const Friend& fr1) const
{
    return this->name() == fr1.name();
}

void Friend::storeData()
{
    if (this->isEmpty())
        return;

    // store albums into cache
    QDomDocument out("MyDoc");

    out.appendChild(this->toQDomElement(out, *this, true));

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(this->accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + "/" + QString(FILE_OWNER_DATA).arg(this->ownerId));
    qDebug() << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();
}

Friend Friend::loadData(const QString& serviceId, const QString& accountId, const QString& ownerId)
{
    Friend ret;
    QFile file(Utils::getAccountDir(accountId) + QString(FILE_OWNER_DATA).arg(ownerId));
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    return Friend::fromQDomElement(doc.firstChildElement(), accountId, serviceId);
}

bool Friend::hasFullProfile() const
{
    QFile file(Utils::getAccountDir(this->accountId) + QString(FILE_OWNER_DATA).arg(this->ownerId));
    if (file.exists())
        return true;

    return false;
}

bool Friend::isMetaProfile() const
{
    if (this->_profiles.length() > 0)
        return true;
    else
        return false;
}

FriendList Friend::getProfileList() const
{
    return this->_profiles;
}

void Friend::addProfile(const Friend& fr, const bool isMainProfile)
{
    if (isMainProfile) {
        this->_isMainProfile = false;
        for (int i = 0; i < this->_profiles.length(); i++)
            this->_profiles[i]._isMainProfile = false;
    }

    this->_profiles.append(fr);
}

bool Friend::hasProfile(const Friend& fr) const
{
    if (this->accountId.compare(fr.accountId) == 0 &&
        this->ownerId.compare(fr.ownerId) == 0)
        return true;

    for (int i = 0; i < this->_profiles.length(); i++) {
        if (fr.accountId.compare(this->_profiles.at(i).accountId) == 0 &&
            fr.ownerId.compare(this->_profiles.at(i).ownerId) == 0)
            return true;
    }

    return false;
}

bool Friend::hasProfile(const QString& serviceId, const QString& ownerId) const
{
    if (this->serviceId.compare(serviceId) == 0 &&
        this->ownerId.compare(ownerId) == 0)
        return true;

    for (int i = 0; i < this->_profiles.length(); i++) {
        if (serviceId.compare(this->_profiles.at(i).serviceId) == 0 &&
            ownerId.compare(this->_profiles.at(i).ownerId) == 0)
            return true;
    }

    return false;
}

FriendList Friend::mergeLists(FriendList src1, FriendList src2)
{
    FriendList ret;

    for (int i = 0; i < src1.length(); i++) {
        Friend fr = src1.at(i);
        for (int j = 0; j < src2.length(); j++) {
            Friend fr2 = src2.at(j);
            if (fr2.hasProfile(fr.serviceId, fr.ownerId)) {
                fr.addProfile(fr2, false);
                src2.removeAt(j);
            }
        }
        ret.append(fr);
    }

    ret.append(src2);

    return ret;
}

bool Friend::isEmpty() const
{
    return this->accountId.isEmpty() || this->ownerId.isEmpty();
}
