#ifndef QERRORMESSAGE_H
#define QERRORMESSAGE_H

/**
  \file qerrormessage.h
  \author MySocials team
  \date 2011-03-30
  */

#include <QObject>
#include <QMetaType>

#define APP_LIBRARY_EXCEPTION_CODE "001"
#define APP_LIBRARY_WRONG_RESPONSE "002"
#define APP_FILE_READ_ERROR "003"
#define APP_FUNCTION_WRONG_ARGS "004"

/**
  \brief Error message class.

  This class describes error message: code, text and comment.
  */
class QErrorMessage : public QObject
{
    Q_OBJECT

public:
    /**
      \brief The default constructor.

      */
    QErrorMessage();

    /**
      \brief The copy constructor.
      */
    QErrorMessage(const QErrorMessage&);

    /**
      \brief The constructor with inistial values of error code and message.

      \param code The error code.

      \param text The error text.
      */
    QErrorMessage(QString code, QString text);

    /**
      \brief The error code.
      */
    QString code;

    /**
      \brief The error text.
      */
    QString text;

    /**
      \brief additional comments corresponded this error.
      */
    QString comment;

    /**
      \brief Copies error function.

      \param dst Destination instance.

      \param src Source instance.
      */
    static void copyData(QErrorMessage *dst, const QErrorMessage *src);
};

Q_DECLARE_METATYPE(QErrorMessage)

#endif // QERRORMESSAGE_H
