#ifndef PHOTOCOMMENT_H
#define PHOTOCOMMENT_H

#include <QObject>
#include <QMetaType>
#include <QDomDocument>

#include "utils/qrefreshlist.h"

class PhotoComment;
typedef QRefreshList<PhotoComment> PhotoCommentList;

#define NODE_PHOTO_COMMENT_ROOT "comment"
#define NODE_PHOTO_COMMENT_ID "id"
#define NODE_PHOTO_COMMENT_SENDER_ID "senderid"
#define NODE_PHOTO_COMMENT_SENDER_NAME "sendername"
#define NODE_PHOTO_COMMENT_TEXT "text"
#define NODE_PHOTO_COMMENT_TIME "time"

class PhotoComment : public QObject
{
    Q_OBJECT
public:
    explicit PhotoComment(QObject *parent = 0);
    PhotoComment(const PhotoComment& source);

    QString accountId;

    QString ownerId;

    QString albumId;

    QString photoId;

    QString commentId;

    QString senderId;

    QString senderName;

    QString time;

    QString text;

    // store data to XML format
    QDomElement toQDomElement(QDomDocument doc);

    // store data to XML format
    static QDomElement toQDomElement(QDomDocument doc, PhotoComment src);

    // load photolist from XML struct
    static PhotoComment fromQDomElement(QDomElement fr, QString accountId, QString friendId, QString albumId, QString photoId);

    static void copyData(PhotoComment *dst, const PhotoComment *src);

    PhotoComment& operator=(const PhotoComment& source);

signals:

public slots:

};

Q_DECLARE_METATYPE(PhotoComment)
//Q_DECLARE_METATYPE(Photo*)
Q_DECLARE_METATYPE(PhotoCommentList)


#endif // PHOTOCOMMENT_H
