#ifndef QIMAGEVIEWER_H
#define QIMAGEVIEWER_H

#include <QMainWindow>
#include <QGraphicsView>
#include <QGraphicsScene>
#include <QGraphicsPixmapItem>
#include <QMessageBox>
#include <QDebug>
#include <QMouseEvent>
#include <QLibrary>
#include <QLabel>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QDesktopWidget>
#include <QGraphicsProxyWidget>
#include <QGraphicsLinearLayout>
#include <QMenuBar>

#include "servicemgr.h"
#include "datatypes/photo.h"
#include "widgets/qmousetrackingview.h"
#include "widgets/qcommentwidget.h"
#include "widgets/qaddcomment.h"

#ifdef Q_WS_MAEMO_5
#include "utils/fullscreenexitbutton.h"
#endif

#ifdef Q_WS_MAEMO_5
#define WINDOW_TITLE "Gallery"
#else
#define WINDOW_TITLE "MySocials Gallery Image Viewer"
#endif

class QImageViewer : public QMainWindow
{
    Q_OBJECT
public:
    explicit QImageViewer(QFont textFont, QWidget *parent = 0);
    ~QImageViewer();

    /**
     * @brief This function set ups photo for showing and open window
     *
     * @param image initial photo for showing
    */
    void loadImage(ServiceMgr *sm, Photo image);

protected:
    void keyPressEvent(QKeyEvent *event);

private:
    /**
     * @brief Shows selected images
    */
    void showImage(bool isNeedCompare);
    void showComments();

    // start photo for slide showing
    Photo currentPhoto;

    // list of photos that are showing
    PhotoList list;

    // service manager
    ServiceMgr *sm;

    // description for photo
    QLabel *description;

    // list of comments
    QWidget *comments;
    QGraphicsProxyWidget *commentsWidget;

    QMouseTrackingView *view;
    QGraphicsScene *scene;

    // container for photos
    QGraphicsPixmapItem *pixmapItem;

    // container for text messages
    QGraphicsTextItem *processItem;

    // the current size of window
    QSize windowSize;

    // index of current showing image
    int currentImageIndex;

    void createMenu();

#ifdef Q_WS_MAEMO_5
    FullScreenExitButton *fullScreenButton;
#endif

signals:

private slots:
    void action_refresh_comments_toggled();
    void action_add_comment_toggled();

public slots:

    void imageListUpdate(QString accountId, QString friendId, QString albumId, PhotoList list, bool isLastUpdate);
    void gotProfile(Friend profile);
    void close();
    void resizeEvent(QResizeEvent *);
    void moveImage(Qt::ArrowType);
    void on_actionFull_screen_toggled();
    void orientationChanged();

    void gotComments(QString photoId, PhotoCommentList list);
};

#endif // QIMAGEVIEWER_H
