#ifndef PROFILEBROWSER_H
#define PROFILEBROWSER_H

/**
  \file profilebrowser.h
  \author MySocials team
  \date 2011-04-01
  */

#include <QWidget>
#include <QPushButton>
#include "datatypes/friend.h"

namespace Ui {
    class ProfileBrowser;
}

/**
  \brief Profile browser widget.

  Shows profile data.
  */
class ProfileBrowser : public QWidget
{
    Q_OBJECT
public:
    /**
      \brief Default constructor.

      \param parent The pointer to parent widget.
      */
    explicit ProfileBrowser(QWidget *parent = 0);

    /**
      \brief Contructor with selected profile.

      \param profile The Friend instance with owner data.

      \param parent The pointer to parent widget.
      */
    explicit ProfileBrowser(Friend profile, QWidget *parent = 0);

    /**
      \brief The destructor.
      */
    ~ProfileBrowser();

    /**
      \brief Sets profile data.

      \param profile  The Friend instance with owner data.
      */
    void setProfile(Friend profile);

private:
    void init();
    Ui::ProfileBrowser *ui;

    Friend currentProfile;

};

#endif // PROFILEBROWSER_H
