#include "profilebrowser.h"
#include "ui_profilebrowser.h"

ProfileBrowser::ProfileBrowser(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ProfileBrowser)
{
    ui->setupUi(this);
    init();
}

ProfileBrowser::ProfileBrowser(Friend profile, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ProfileBrowser)
{
    ui->setupUi(this);
    init();

    this->setProfile(profile);
}

ProfileBrowser::~ProfileBrowser()
{
    delete ui;
}

void ProfileBrowser::init()
{
    ui->photoLabel->setMinimumWidth(100);
    this->ui->photoLabel->setPixmap(QIcon(":/res/general_default_avatar.png").pixmap(100));
}

void ProfileBrowser::setProfile(Friend profile)
{
    if (this->currentProfile.firstName().compare(profile.firstName()) != 0)
        this->ui->firstNameLineEdit->setText(profile.firstName());

    if (this->currentProfile.nickName().compare(profile.nickName()) != 0)
        this->ui->nickLineEdit->setText(profile.nickName());

    if (this->currentProfile.lastName().compare(profile.lastName()) != 0)
        this->ui->lastNameLineEdit->setText(profile.lastName());

    if (this->currentProfile.gender().compare(profile.gender()) != 0)
        this->ui->genderLineEdit->setText(profile.gender());

    if (this->currentProfile.birthday().compare(profile.birthday()) != 0)
        this->ui->birthdayLineEdit->setText(profile.birthday());

    if (this->currentProfile.city().compare(profile.city()) != 0)
        this->ui->cityLineEdit->setText(profile.city());

    if (this->currentProfile.country().compare(profile.country()) != 0)
        this->ui->countryLineEdit->setText(profile.country());

    if (this->currentProfile.mobilePhone().compare(profile.mobilePhone()) != 0)
        this->ui->mobilePhoneLineEdit->setText(profile.mobilePhone());

    if (this->currentProfile.homePhone().compare(profile.homePhone()) != 0)
        this->ui->homePhoneLineEdit->setText(profile.homePhone());

    if (this->currentProfile.icon().compare(profile.icon()) != 0) {
        if (profile.icon().isEmpty())
            this->ui->photoLabel->setPixmap(QIcon(":/res/general_default_avatar.png").pixmap(100));
        else
            this->ui->photoLabel->setPixmap(QIcon(profile.icon()).pixmap(100));
    }
    this->currentProfile = profile;
}
