#include "profilebrowserpanel.h"
#include "ui_profilebrowserpanel.h"

#include <QTimer>

ProfileBrowserPanel::ProfileBrowserPanel(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::ProfileBrowserPanel),
        isPortraitMode(false),
        isSkipFriendUpdate(false),
        state(WindowFriendList)
{
    this->sm = new ServiceMgr(this);
    ui->setupUi(this);

    init();
}

ProfileBrowserPanel::ProfileBrowserPanel(ServiceMgr *mgr, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ProfileBrowserPanel),
    isPortraitMode(false),
    isSkipFriendUpdate(false),
    state(WindowFriendList)
{
    if (mgr != NULL)
        this->sm = mgr;
    else
        this->sm = new ServiceMgr(this);
    ui->setupUi(this);

    init();
}

ProfileBrowserPanel::~ProfileBrowserPanel()
{
    delete ui;
}

void ProfileBrowserPanel::init()
{
    pb = new ProfileBrowser(this);
    ui->layoutProfile->addWidget(pb, 0);

    buttonBack = new QPushButton(this);
    buttonBack->setIcon(QIcon::fromTheme("general_back",
                                         QIcon(":/res/general_back.png")));
    buttonBack->setFlat(TRUE);
    ui->layoutProfileTop->addWidget(buttonBack, 1);
    buttonBack->setVisible(FALSE);

    buttonAlbums = new QPushButton(tr("Albums"));
#ifdef Q_WS_MAEMO_5
    buttonAlbums->setText(QString(""));
#endif
    buttonAlbums->setIcon(QIcon(":/res/tasklaunch_photos.png"));
    buttonAlbums->setFlat(TRUE);
    buttonAlbums->setEnabled(FALSE);
    ui->layoutProfileTop->addWidget(buttonAlbums, 1);

    buttonMessages = new QPushButton(tr("Messages"));
#ifdef Q_WS_MAEMO_5
    buttonMessages->setText(QString(""));
#endif
    buttonMessages->setIcon(QIcon(":/res/messages.png"));
    buttonMessages->setFlat(TRUE);
    buttonMessages->setEnabled(FALSE);
    ui->layoutProfileTop->addWidget(buttonMessages, 1);

    buttonSendMsg = new QPushButton(tr("Send message"));
#ifdef Q_WS_MAEMO_5
    buttonSendMsg->setText(QString(""));
#endif
    buttonSendMsg->setIcon(QIcon(":/res/message.png"));
    buttonSendMsg->setFlat(TRUE);
    buttonSendMsg->setEnabled(FALSE);
    ui->layoutProfileTop->addWidget(buttonSendMsg, 1);

    peopleradb = new QRadioButton(tr("People (%1)").arg("0"));
    peopleradb->toggle();
    peopleradb->setEnabled(FALSE);
    ui->layoutFriendsTop->addWidget(peopleradb, 1);
    QRadioButton *radb = new QRadioButton(tr("News"));
    radb->setEnabled(FALSE);
    ui->layoutFriendsTop->addWidget(radb, 1);
    ui->layoutFriendsTop->setSpacing(0);

    // friends list
    ui->layoutFriendsTop->addWidget(buttonRefreshFriends = new QPushButton(this), 0);
    buttonRefreshFriends->setFlat(TRUE);
    buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));

    ui->listFriends->setStyleSheet("text-align: left; image-position: center;");
    ui->listFriends->setFont(this->usedFont);

    //friends filter
    ui->layoutFriendsBottom->addWidget(editOwnr = new HintEdit(this));
    ui->layoutFriendsBottom->addWidget(buttonEditOwnr = new QPushButton(this));

    buttonEditOwnr->setIcon(QIcon::fromTheme("general_backspace", QIcon(":/res/general_backspace.png")));
    buttonEditOwnr->setFlat(TRUE);
    editOwnr->setHintText(tr("Type a name..."));

    connect(buttonBack, SIGNAL(clicked()), this, SLOT(hideProfile()));
    connect(buttonAlbums, SIGNAL(clicked()), this, SLOT(showFriendAlbums()));
    connect(buttonMessages, SIGNAL(clicked()), this, SLOT(showFriendMessages()));
    connect(buttonSendMsg, SIGNAL(clicked()), this, SLOT(sendMessageToFriend()));
    connect(editOwnr, SIGNAL(textChanged(QString)), this,
            SLOT(editOwnr_textChanged(QString)));
    connect(buttonEditOwnr, SIGNAL(clicked()), this,
            SLOT(buttonResetOwnr_clicked()));
    connect(ui->listFriends, SIGNAL(itemClicked(QListWidgetItem*)), this,
            SLOT(ownrSelected(QListWidgetItem*)));
    connect(buttonRefreshFriends, SIGNAL(clicked()), this,
            SLOT(refreshFriends()));
    connect(ui->listFriends, SIGNAL(itemActivated(QListWidgetItem*)), this,
            SLOT(ownrSelected(QListWidgetItem*)));

    connect(this->sm, SIGNAL(updateAccounts(AccountList)), this,
            SLOT(updateAccounts(AccountList)));

    // device rotation
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    this->isFriendsUpdate = false;

    // connect to signals from service manager
    connect(sm, SIGNAL(updateFriends(FriendList, bool)), this,
            SLOT(updateListFriends(FriendList, bool)));
    connect(sm, SIGNAL(updateProfile(Friend)), this, SLOT(updateProfile(Friend)));

    // check that one acount mast be setup
    if (this->sm->getAccounts().length() != 0)
        this->updateListFriends(sm->getFriends(false, true), true);

    this->setState();
}

void ProfileBrowserPanel::buttonResetOwnr_clicked()
{
    editOwnr->clear();
}

void ProfileBrowserPanel::editOwnr_textChanged(QString str)
{
    int num = ui->listFriends->count();
    if (str.count() > 0)
    {
        for (int i = 0; i < num; i++)
            if (ui->listFriends->item(i)->text().indexOf(str, 0, Qt::CaseInsensitive) < 0)
                ui->listFriends->item(i)->setHidden(TRUE);
            else
                ui->listFriends->item(i)->setHidden(FALSE);
    } else {
        for (int i = 0; i < num; i++)
            ui->listFriends->item(i)->setHidden(FALSE);
    }
    ui->listFriends->scrollTo(ui->listFriends->currentIndex());
}

void ProfileBrowserPanel::updateAccounts(AccountList )
{
    if (this->sm->getAccounts().length() != 0)
        this->updateListFriends(sm->getFriends(false, true), true);
}

void ProfileBrowserPanel::addMeToFriends()
{
    bool isEnabledAccountFound = false;
    Friend myProfile;
    AccountList accs = this->sm->getAccounts();
    for (int i = 0; i < accs.length(); i++) {
        if (accs.at(i)->isNetworkEnabled) {
            myProfile = accs.at(i)->getProfile(false);
            isEnabledAccountFound = true;
            break;
        }
    }
    if (!isEnabledAccountFound && accs.length() > 0)
        myProfile = accs.at(0)->getProfile(false);

    qDebug() << __FILE__<<":" << __LINE__ << ": profile icon:" << myProfile.icon();
    QListWidgetItem *item = this->createFriendWidget(myProfile);
    ui->listFriends->insertItem(0, item);
}


QListWidgetItem* ProfileBrowserPanel::createFriendWidget(Friend fr)
{
    QListWidgetItem *item = new QListWidgetItem(fr.name());
    QImage img = QImage(fr.icon());

    if (!img.isNull()) {
        if (img.height() > img.width())
            img = img.copy(0, (img.height() - img.width()) / 2, img.width(), img.width());

        if (img.width() > img.height())
            img = img.copy((img.width() - img.height()) / 2, 0, img.height(), img.height());

        item->setIcon(QIcon(QPixmap::fromImage(img)));
    }

    if (item->icon().isNull())
        item->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));

    QVariant v;
    v.setValue(fr);
    item->setData(Qt::UserRole, v);

    return item;
}

void ProfileBrowserPanel::ownrSelected(QListWidgetItem *item, bool isNeedUpdateState)
{
    qDebug() << "Friend selected: " << item->text();

    QVariant v = item->data(Qt::UserRole);
    if (v.canConvert<Friend>()) {
        Friend fd = v.value<Friend>();
        qDebug() << "Get profile for " << fd.ownerId;

        if (!fd.accountId.isEmpty() && !fd.ownerId.isEmpty()) {
            updateProfile(fd);
            emit openProfile(fd);
            this->sm->getProfile(fd.accountId, fd.ownerId, false, true, !fd.isFullProfile());
        } else {
            qDebug() << "No friends.";
        }

        if (isNeedUpdateState)
            this->setState(WindowProfile);
    }
}

void ProfileBrowserPanel::updateProfile(Friend profile)
{
    if (ui->listFriends->selectedItems().count() != 0) {
        QListWidgetItem* item = ui->listFriends->selectedItems().first();
        QVariant v = item->data(Qt::UserRole);

        if (v.canConvert<Friend>()) {
            Friend fd = v.value<Friend>();

            if (profile.ownerId == fd.ownerId) {
                pb->setProfile(profile);
                this->buttonAlbums->setEnabled(TRUE);
                this->buttonMessages->setEnabled(TRUE);
                this->buttonSendMsg->setEnabled(TRUE);
            }
        }
    }
}

void ProfileBrowserPanel::ownrSelected(QListWidgetItem *item)
{
    this->ownrSelected(item, true);
}

void ProfileBrowserPanel::updateListFriends(FriendList list, bool isLastUpdate)
{
    // skip non-last friends updates if it possible
    if (!isLastUpdate && this->isSkipFriendUpdate)
        return;

    qDebug() << "Start update Friend list process. isLastUpdate=" << isLastUpdate;

    if (isLastUpdate) {
        this->isFriendsUpdate = false;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_refresh", QIcon(":/res/general_refresh.png")));
    } else {
        this->isFriendsUpdate = true;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
    }

    if (list.isEmpty()) {
        this->ui->listFriends->clear();
        this->addMeToFriends();
        if (isLastUpdate) {
            new QListWidgetItem(tr("No Friends"), this->ui->listFriends);
        } else {
            new QListWidgetItem(tr("Download friend list"), this->ui->listFriends);
        }
        return;
    }

    if (this->ui->listFriends->count() == 0)
        this->addMeToFriends();

    FriendList newFriends(list);
    QList<QListWidgetItem *> dels;

    // check that all current friends is contains in new list
    for (int i = 1; i < ui->listFriends->count(); i++) {
        bool isFound = false;

        QListWidgetItem *item = ui->listFriends->item(i);

        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Friend>()) {
            Friend oldFd = v.value<Friend>();

            int removedVal = -1;

            for (int j = 0; j < newFriends.length(); j++) {
                Friend curFd = newFriends.at(j);
                if (oldFd.ownerId == curFd.ownerId &&
                    oldFd.accountId == curFd.accountId) {
                    removedVal = j;
                    QImage *img = new QImage(curFd.icon());
                    if (img->height() > img->width())
                        *img = img->copy(0, (img->height() - img->width()) / 2, img->width(), img->width());
                    item->setIcon(QIcon(QPixmap::fromImage(*img)));
                    if (item->icon().isNull())
                        item->setIcon(QIcon::fromTheme("general_default_avatar", QIcon(":/res/general_default_avatar.png")));
                    v.setValue(curFd);
                    item->setData(Qt::UserRole, v);

                    isFound = true;
                    delete img;
                    break;
                }
            }

            if (isFound && removedVal >= 0) {
                newFriends.removeAt(removedVal);
            } else {
                qDebug() << "prepare to remove friend with id " << oldFd.ownerId << " from " << oldFd.accountId;
            }
        }

        if (!isFound)
            dels.append(item);
    }

    qDebug() << "Will be add " << newFriends.length() << " friends and removed " << dels.length() << " records. Total widgets: " << ui->listFriends->count();

    // del old friends
    for (int i = 0; i < dels.length(); i++) {
        if (dels.at(i)->isSelected()) {
            this->ui->listFriends->item(0)->setSelected(true);
            this->ownrSelected(this->ui->listFriends->item(0), false);
        }
        delete dels.at(i);
    }

    // add new Friends with asceding sorting
    for (int i = 0; i < newFriends.length(); i++) {
        QListWidgetItem *item = createFriendWidget(newFriends.at(i));
        if (this->ui->listFriends->count() <= 1)
            this->ui->listFriends->addItem(item);

        bool flag = false;
        for (int j = 1; j < this->ui->listFriends->count(); j++) {
            if (this->ui->listFriends->item(j)->text().compare(item->text()) > 0) {
                this->ui->listFriends->insertItem(j, item);
                flag = true;
                break;
            }
        }
        if (!flag)
            this->ui->listFriends->addItem(item);
    }

    if (this->ui->listFriends->selectedItems().count() == 0) {
        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): no selected items in friend list!";

        this->ui->listFriends->item(0)->setSelected(true);
        this->ui->listFriends->selectedItems().append(this->ui->listFriends->item(0));
        this->ownrSelected(this->ui->listFriends->item(0), false);

        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): Selected me!!!";
    }

    this->peopleradb->setText(tr("People (%1)").arg(this->ui->listFriends->count()));

    // set timeout for next updates
    if (!isLastUpdate) {
        this->isSkipFriendUpdate = true;
        QTimer::singleShot(1000, this, SLOT(disableFriendSkipUpdate()));
    }
}

void ProfileBrowserPanel::refreshFriends()
{
    this->refreshFriends(true);
}

void ProfileBrowserPanel::refreshFriends(bool isNeedUpdate)
{
    if (!this->isFriendsUpdate) {
        buttonResetOwnr_clicked();
        this->isFriendsUpdate = true;
        buttonRefreshFriends->setIcon(QIcon::fromTheme("general_stop", QIcon(":/res/general_stop.png")));
        sm->getFriends(isNeedUpdate, true);
    } else {
        // TODO: add stopping friends update
    }
}

void ProfileBrowserPanel::setState()
{
    this->setState(this->state);
}

void ProfileBrowserPanel::setState(WindowState state) {
    this->state = state;
    bool isMultiWindow = this->sm->settings->value(SETTINGS_MULTIPANEL).toBool() && !this->isPortraitMode;

    switch(this->state) {
    case WindowFriendList:
        showAll(ui->layoutFriends);
        hideAll(ui->layoutProfiles);

        if (isMultiWindow) {
            showAll(ui->layoutProfiles);
            buttonBack->setVisible(FALSE);
        } else {
            hideAll(ui->layoutProfiles);
        }
        break;
    case WindowProfile: // from photo to album
        showAll(ui->layoutProfiles);
        hideAll(ui->layoutFriends);

        if (isMultiWindow) {
            showAll(ui->layoutFriends);
            buttonBack->setVisible(FALSE);
        } else {
            hideAll(ui->layoutFriends);
            buttonBack->setVisible(TRUE);
        }
        break;
    default:
        QMessageBox::warning(this, tr("Error occured"), tr("Unknown window state"));
        break;
    }
}

void ProfileBrowserPanel::hideAll(QLayout *layout)
{
    for (int i = 0; i < layout->count(); i++) {
        if(layout->itemAt(i)->layout()) {
            hideAll(layout->itemAt(i)->layout());
        } else {
            layout->itemAt(i)->widget()->setVisible(FALSE);
        }
    }
}
void ProfileBrowserPanel::showAll(QLayout *layout)
{
    for (int i = 0; i < layout->count(); i++) {
        if(layout->itemAt(i)->layout()) {
            showAll(layout->itemAt(i)->layout());
        } else {
            layout->itemAt(i)->widget()->setVisible(TRUE);
        }
    }
}

void ProfileBrowserPanel::hideProfile()
{
    this->setState(WindowFriendList);
}

void ProfileBrowserPanel::showFriendInfo(Friend fd)
{
    for (int i = 0; i < ui->listFriends->count(); i++) {
        QListWidgetItem *item = ui->listFriends->item(i);

        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Friend>()) {
            Friend oldFd = v.value<Friend>();

            if (oldFd.ownerId == fd.ownerId) {
                ui->listFriends->setCurrentRow(i);
                ownrSelected(item);
                break;
            }
        }
    }
}

void ProfileBrowserPanel::showFriendAlbums()
{
    QListWidgetItem *item = ui->listFriends->selectedItems().first();
    if (item != NULL) {
        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Friend>()) {
            Friend fd = v.value<Friend>();
            qDebug() << __FILE__ << "emit showFriendAlbums";
            emit showFriendAlbums(fd);
        }
    }
}

void ProfileBrowserPanel::showFriendMessages()
{
    QListWidgetItem *item = ui->listFriends->selectedItems().first();
    if (item != NULL) {
        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Friend>()) {
            Friend fd = v.value<Friend>();
            qDebug() << __FILE__ << "emit showFriendMessages";
            emit showFriendMessages(fd);
        }
    }
}

void ProfileBrowserPanel::sendMessageToFriend()
{
    QListWidgetItem *item = ui->listFriends->selectedItems().first();
    if (item != NULL) {
        QVariant v = item->data(Qt::UserRole);
        if (v.canConvert<Friend>()) {
            Friend fd = v.value<Friend>();
            qDebug() << __FILE__ << "emit sendMessage";
            emit sendMessage(fd);
        }
    }
}

void ProfileBrowserPanel::disableFriendSkipUpdate()
{
    this->isSkipFriendUpdate = false;
}

void ProfileBrowserPanel::orientationChanged()
{
    QRect geom = QApplication::desktop()->screenGeometry();
    if (geom.width() > geom.height())
        this->isPortraitMode = false;
    else
        this->isPortraitMode = true;
}
