#ifndef DRIVERINFO_H
#define DRIVERINFO_H

#include <QObject>
#include <QIcon>
#include <QMetaType>

/**
  \brief Class for store service information

  This structure store driver information: display name, driver name,
  service icon and path to library.
  */
class DriverInfo : public QObject
{
    Q_OBJECT
public:
    /**
      \brief An constructor.

      \param parent The pointer to parent object.
      */
    explicit DriverInfo(QObject *parent = 0);

    /**
      \brief Copy constructor.

      \param src The DriverInfo instance.
      */
    DriverInfo(DriverInfo &src);

    /**
      \brief Service dispay name.

      Contains origin name of service which can be displayed.
      */
    QString name;

    QString serviceName;

    /**
      \brief Service icon.

      Contains origin icon of service.
      */
    QIcon icon;

    /**
      \brief Path to library.

      Contains path to library driver.
      */
    QString library;

signals:

public slots:

};

Q_DECLARE_METATYPE(DriverInfo *)

#endif // DRIVERINFO_H
