/**
  \file messagebrowser.h
  \brief MessageBrowser class description
  \author MySocials team
  \date 2011-03-23
  */
#ifndef MESSAGEBROWSER_H
#define MESSAGEBROWSER_H

#include <QWidget>
#include "datatypes/message.h"

namespace Ui {
    class MessageBrowser;
}

/*!
 \class MessageBrowser
 \brief Widget for showing message data.

 This class is using for showing message data such as subject, recepients, sender
 and message body.

 \see Message
 */
class MessageBrowser : public QWidget
{
    Q_OBJECT
public:

    /*!
     A MessageBrowser constructor.

     \param parent Pointer to parent widget.
     */
    explicit MessageBrowser(QWidget *parent = 0);

    /*!
     A MessageBrowser constructor.

     \param msg Message which is using for filling MessageBrowser fields

     \param parent Pointer to parent widget
     */
    explicit MessageBrowser(Message msg, QWidget *parent);

    //! A destructor.
    ~MessageBrowser();

    /*!
     \brief Sets current message.

     \param msg Message which is using for filling MessageBrowser fields
     */
    void setMessage(Message msg);

    /*!
     \brief Gets title of message.
     */
    QString title();

    /*!
     \brief Gets list of recepients.
     */
    QStringList to();

    /*!
     \brief Gets sender of message.
     */
    QString from();

    /*!
     \brief Gets message body.
     */
    QString message();

    /*!
     \brief Clears all fields of message form.
     */
    void resetMessage();

private:
    Ui::MessageBrowser *ui;
};

#endif // MESSAGEBROWSER_H
