#include "uiaddaccount.h"
#include "ui_uiaddaccount.h"

UIAddAccount::UIAddAccount(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UIAddAccount)
{
    this->sm = sm;
    ui->setupUi(this);
    qDebug() << "add new account";
    QList<DriverInfo*> drivers = this->sm->getDrivers();
    qDebug() << "loaded " << drivers.length() << " drivers";

    for (int i = 0; i < drivers.length(); i++) {
        QListWidgetItem *item = new QListWidgetItem(drivers.at(i)->name, this->ui->listDrivers);
        item->setIcon(drivers.at(i)->icon);
        QVariant v;
        v.setValue(drivers.at(i));
        item->setData(Qt::UserRole, v);
    }

    this->ui->lblDescription->setText(tr("Input account name and select one of services"));

    connect(this->ui->buttonBox, SIGNAL(accepted()), this, SLOT(verify()));

}

UIAddAccount::~UIAddAccount()
{
    delete ui;
}

void UIAddAccount::verify()
{
    if (this->ui->accointName->text().isEmpty()) {
        this->ui->lblDescription->setText(tr("Input name of service!"));
        return;
    }

    QDir dir(Utils::getAccountDir(this->ui->accointName->text()));
    if (dir.exists()) {
        this->ui->lblDescription->setText(tr("This account name already exists!"));
        return;
    }

    // check that driver is selected
    if (this->ui->listDrivers->selectedItems().length() == 0) {
        this->ui->lblDescription->setText(tr("Select one of services!"));
        return;
    }

    // all tests passed. Try to add account
    QList<QListWidgetItem *> selItems = this->ui->listDrivers->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<DriverInfo *>()) {
            DriverInfo * fd = v.value<DriverInfo *>();
            this->sm->addAccount(this->ui->accointName->text(), fd);
        }
    }

    accept();
}
