#include "uiaccountsettings.h"
#include "ui_uiaccountsettings.h"

UIAccountSettings::UIAccountSettings(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UIAccountSettings)
{
    ui->setupUi(this);
    this->sm = sm;

    AccountList acc = this->sm->getAccounts();
    this->updateAccounts(acc);

    connect(this->sm, SIGNAL(updateAccounts(AccountList)), this, SLOT(updateAccounts(AccountList)));
    connect(this->ui->listSettings, SIGNAL(itemSelectionChanged()), this, SLOT(selectAccount()));
}

UIAccountSettings::~UIAccountSettings()
{
    delete ui;
}

void UIAccountSettings::on_btnAddNew_clicked() {
    UIAddAccount *drvForm = new UIAddAccount(this->sm, this);
    drvForm->setModal(true);
    drvForm->show();
}

void UIAccountSettings::updateAccounts(AccountList acc)
{
    this->ui->listSettings->clear();
    for (int i = 0; i < acc.length(); i++) {
        DriverInfo *info = acc.at(i)->transport->getDriverInfo();
        QString title = acc.at(i)->transport->accountId + " (" + info->name + ")\n" +
                        acc.at(i)->getProfile(false).name();
        if (!acc.at(i)->isNetworkEnabled)
            title += tr(" (offline mode)");
        QListWidgetItem *item = new QListWidgetItem(title, this->ui->listSettings);
        QIcon curIcon(acc.at(i)->getProfile(false).icon);
        if (curIcon.isNull())
            item->setIcon(info->icon);
        else
            item->setIcon(curIcon);
        QVariant v;
        v.setValue(acc.at(i));
        item->setData(Qt::UserRole, v);
    }
}

void UIAccountSettings::selectAccount()
{
    this->ui->btnRemove->setEnabled(true);
    this->ui->btnReconnect->setEnabled(true);
}

void UIAccountSettings::on_btnRemove_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            this->sm->deleteAccount(fd);
        }
    }
}

void UIAccountSettings::on_btnReconnect_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            fd->isFirstRequest = true;
            fd->getProfile(true);
        }
    }
}

void UIAccountSettings::addNewAccount()
{
    this->show();
    this->on_btnAddNew_clicked();
}
