#include "qmousetrackingview.h"

QMouseTrackingView::QMouseTrackingView(QGraphicsScene *scene, QWidget *parent) :
    QGraphicsView(scene, parent), lastMouseEvent(QEvent::None,QPoint(),Qt::NoButton,Qt::NoButton,Qt::NoModifier)
{
    setDragMode(QGraphicsView::NoDrag);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
#ifdef Q_WS_MAEMO5
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff) ;
#endif
    setTransformationAnchor(QGraphicsView::AnchorUnderMouse);
}

void QMouseTrackingView::reset()
{
    this->mousePoints.clear();
}

void QMouseTrackingView::mousePressEvent(QMouseEvent * event)
{
    if (event->button() == Qt::LeftButton) {
        this->mousePoints.clear();
        this->mousePoints.append(event->pos());
//        qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "() Pressed at " << event->pos() << " scene:" << this->sceneRect();
        this->storeMouseEvent(event);
    }
}

void QMouseTrackingView::mouseMoveEvent(QMouseEvent * event)
{

    if (!(event->buttons() & Qt::LeftButton))
        return;

    if (this->mousePoints.length() <= NUM_MOVE_EVENTS)
        this->mousePoints.append(event->pos());

    //qDebug() << __FILE__ << ":" << __LINE__ << ": points=" << this->mousePoints.length();
//    event->ignore();
//    QPoint scenePos = event->pos() - this->startMovePoint;
//    scenePos.setX(this->sceneRect().x());
//    this->scroll(scenePos.x(), scenePos.y());

    QPoint delta = event->globalPos() - lastMouseEvent.globalPos();
    QScrollBar *vBar = verticalScrollBar();
//    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "(): delta=" << delta <<
//            "; vBar=" << vBar->value() << " < max=" << vBar->maximum();

    vBar->setValue(vBar->value() - delta.y());
    //    QPoint delta = event->globalPos() - lastMouseEvent.globalPos();
//    QScrollBar *vBar = verticalScrollBar();
//    vBar->setValue(vBar->value() - delta.y());
    storeMouseEvent(event);
    event->accept();
}

void QMouseTrackingView::storeMouseEvent(QMouseEvent *event)
{
    lastMouseEvent = QMouseEvent(event->type(), event->pos(),
                                 event->globalPos(),
                                 event->button(),event->buttons(),event->modifiers());
}

void QMouseTrackingView::mouseReleaseEvent(QMouseEvent *event)
{
    if (!(event->buttons() && Qt::LeftButton))
    {
  //      qDebug() << __FILE__ << ":" << __LINE__ << __FUNCTION__ << "(): pos=" << event->pos();
        this->mousePoints.append(event->pos());
        this->getDirection();
    }
}

void QMouseTrackingView::mouseDoubleClickEvent(QMouseEvent *)
{
    emit this->mouseDoubleClick();
}

void QMouseTrackingView::getDirection()
{
//    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "() startPoint=" <<this->mousePoints.at(0)
//            << " endpoint=" << this->mousePoints.at(this->mousePoints.length() - 1);

    if (this->mousePoints.length() < NUM_MOVE_EVENTS)
        return;

    if ((this->mousePoints.at(0) - this->mousePoints.at(this->mousePoints.length() - 1)).manhattanLength()
        < 4*QApplication::startDragDistance())
        return;

    int dx = this->mousePoints.at(0).x() - this->mousePoints.at(this->mousePoints.length() - 1).x();
    int dy = this->mousePoints.at(0).y() - this->mousePoints.at(this->mousePoints.length() - 1).y();
//    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "() dx=" << dx << " dy=" << dy;

    Qt::ArrowType direction;
    if(abs(dx) * 2 > abs(dy))
    {
        if (dx > 0)
            direction = Qt::RightArrow;
        else
            direction = Qt::LeftArrow;
    } else {
        if (dy > 0)
            direction = Qt::UpArrow;
        else
            direction = Qt::DownArrow;
    }
//    qDebug() << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << "() direction=" << direction;
    this->mousePoints.clear();
    emit this->mouseDragged(direction);
}
