#ifndef UTILS_H
#define UTILS_H

#include <QString>
#include <QDir>
#include <QDomDocument>
#include <QDesktopServices>

#include "datatypes/photo.h"
#include "datatypes/album.h"

#define DATE_TIME_FORMAT "dd.MM.yyyy hh:mm:ss"

#define FRIEND_ICONS_DIR "friend_icons/"
#define ALBUM_ICONS_DIR "album_icons/"
#define DRIVER_LIBRARY_DIR "/msa/drivers/"

class Utils
{
public:
    Utils();
    static QString getHomeDir(); // get home directory.

    /**
     * @brief get path to folder for friend icons corresponded the name of service
     *
     * @param serviceName the name of service
     * @return QString path to folder
    */
    static QString getFriendsIconDir(QString serviceName); // get friends avatars directory.
    static QString getFriendsIconDir(char * serviceName); // get friends avatars directory.

    static QString getAlbumsIconDir(QString serviceName); // get albums icons directory.
    static QString getAlbumsIconDir(char * serviceName); // get albums icons directory.

    static QString getPhotoDir(QString serviceName); // get image directory.
    static QString getPhotoDir(char * serviceName); // get image directory.

    /**
     * @brief get absolute path to account dir
     *
     * @param accountId the name of account
     * @return QString absolute path
    */
    static QString getAccountDir(QString accountId);
    static QString decodeString(QString str); // decode string with xml characters

    /**
     * @brief get path to folder of MySocials drivers
     *
     * @return QString absolute path to folder
    */
    static QString getDriversDir();
    static bool RemoveDirectory(QDir &aDir);
    static bool RemoveFiles(QDir &aDir, QString filter);

    static QString getPhotoListKey(PhotoList photos);
    static QString getPhotoListKey(Album album);

    static QString getDataDir();

    static QString getPhotoCommentListKey(Photo photo);
};

#endif // UTILS_H
