# -------------------------------------------------
# Project created by QtCreator 2010-08-12T14:46:35
# -------------------------------------------------
QT = core \
    gui \
    xml \
    network \
    webkit
    
TARGET_NAME = mysocials

unix: {
     CONFIG (debug, debug|release) {
             # the name for debug version
             TARGET = $${TARGET_NAME}d
     } else {
             # the name for release version
             TARGET = $$TARGET_NAME
     }
} else {
     TARGET = $$qtLibraryTarget($$TARGET_NAME)
}

VERSION = 1.0

TEMPLATE = lib

CONFIG += link_pkgconfig \
    thread \
    debug_and_release \
    build_all
    
PKGCONFIG += libxml-2.0 \
    glib-2.0 

DEFINES += mysocials_LIBRARY

CONFIG (debug, debug|release) {
     OBJECTS_DIR = build/debug
} else {
     OBJECTS_DIR = build/release
}

# include private developer settings
exists(../devel.pri):include(../devel.pri)

DEFINES += LOCALDATADIR=\\\"/.msa/\\\"

isEmpty(PREFIX):PREFIX = $$[QT_INSTALL_PREFIX]
message(prefix is $$PREFIX)

# prefix for search shared files
exists($$PREFIX) { 
    DATAPREFIX = $$PREFIX/share
    DEFINES += DATAPREFIX=\\\"$$DATAPREFIX\\\"
    message(dataprefix is $$DATAPREFIX)
    BINDIR = $$PREFIX/bin
    LIBDIR = $$PREFIX/lib
    !maemo5:contains(QMAKE_HOST.arch, x86_64):{
	LIBDIR = $$PREFIX/lib64
    }
    INCLUDEDIR = $$PREFIX/include
    DATADIR = $$PREFIX/share
}

RESOURCES += ../data/res.qrc

SOURCES += \
    utils/hintedit.cpp \
    utils/QProgressIndicator.cpp \
    utils/utils.cpp \
    widgets/qmousetrackingview.cpp \
    servicemgr.cpp \
    datatypes/photo.cpp \
    datatypes/account.cpp \
    datatypes/friend.cpp \
    datatypes/album.cpp \
    datatypes/driverinfo.cpp \
    datatypes/message.cpp \
    qtransport.cpp \
    datatypes/photocomments.cpp \
    widgets/qcommentwidget.cpp \
    datatypes/qerrormessage.cpp \
    widgets/qaddcomment.cpp \
    widgets/qimageviewer.cpp \
    widgets/uiaccountsettings.cpp \
    widgets/uiaddaccount.cpp \
    widgets/uihelp.cpp \
    widgets/uinetworksettings.cpp \
    widgets/qdriverslist.cpp \
    panels/imagebrowserpanel.cpp \
    widgets/qtoppanel.cpp

HEADER_CORE = mysocials_global.h \
    mysocials_driver.h \
    servicemgr.h \
    qtransport.h

HEADER_UTILS = \
    utils/hintedit.h \
    utils/QProgressIndicator.h \
    utils/utils.h \
    utils/fullscreenexitbutton.h

HEADER_WIDGETS = \
    widgets/qmousetrackingview.h \
    widgets/qcommentwidget.h \
    widgets/qaddcomment.h \
    widgets/qimageviewer.h \
    widgets/uiaccountsettings.h \
    widgets/uiaddaccount.h \
    widgets/uihelp.h \
    widgets/uinetworksettings.h \
    widgets/qdriverslist.h \
    widgets/qtoppanel.h

HEADER_DATATYPES = \
    datatypes/photo.h \
    datatypes/account.h \
    datatypes/friend.h \
    datatypes/album.h \
    datatypes/driverinfo.h \
    datatypes/photocomments.h \
    datatypes/qerrormessage.h \
    datatypes/message.h
    
HEADER_PANELS = \
    panels/imagebrowserpanel.h
    
HEADERS += \
    $$HEADER_UTILS \
    $$HEADER_DATATYPES \
    $$HEADER_CORE \
    $$HEADER_WIDGETS \
    $$HEADER_PANELS

FORMS += \
    widgets/qaddcomment.ui \
    widgets/uiaccountsettings.ui \
    widgets/uiaddaccount.ui \
    widgets/uihelp.ui \
    widgets/uinetworksettings.ui \
    widgets/qdriverslist.ui \
    panels/imagebrowserpanel.ui

CODECFORSRC = UTF-8
TRANSLATIONS = ../translations/$${TARGET_NAME}_core_ru.ts

system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials:g;s:@VERSION@:$$VERSION:g' ../data/mysocials-dev.pc.in >../data/mysocials-dev.pc")
system("sed -e 's:@prefix@:$$PREFIX:g;s:@exec_prefix@:$$BINDIR:g;s:@libdir@:$$LIBDIR:g;s:@includedir@:$$INCLUDEDIR/mysocials:g;s:@VERSION@:$$VERSION:g' ../data/mysocials-core.pc.in >../data/mysocials-core.pc")



# make install
INSTALLS += target pkgconfig header_core header_utils header_types header_widgets header_panels
target.path = $$LIBDIR

pkgconfig.path = $$LIBDIR/pkgconfig
pkgconfig.files = ../data/*.pc

header_core.path = $$INCLUDEDIR/mysocials
header_core.files = $$HEADER_CORE

header_utils.path = $$INCLUDEDIR/mysocials/utils
header_utils.files = $$HEADER_UTILS

header_types.path = $$INCLUDEDIR/mysocials/datatypes
header_types.files = $$HEADER_DATATYPES

header_widgets.path = $$INCLUDEDIR/mysocials/widgets
header_widgets.files = $$HEADER_WIDGETS

header_panels.path = $$INCLUDEDIR/mysocials/panels
header_panels.files = $$HEADER_PANELS
