#include "photocomments.h"

PhotoComment::PhotoComment(QObject *parent) :
    QObject(parent)
{
}

PhotoComment::PhotoComment(const PhotoComment &src)
    : QObject(src.parent())
{
    PhotoComment::copyData(this, &src);
}

void PhotoComment::copyData(PhotoComment *dst, const PhotoComment *src)
{
    dst->accountId = src->accountId;
    dst->albumId = src->albumId;
    dst->commentId = src->commentId;
    dst->ownerId = src->ownerId;
    dst->photoId = src->photoId;
    dst->senderId = src->senderId;
    dst->senderName = src->senderName;
    dst->text = src->text;
    dst->time = src->time;
}

PhotoComment PhotoComment::fromQDomElement(QDomElement fr, QString accountId, QString friendId, QString albumId, QString photoId) {
    PhotoComment ret;

    ret.accountId = accountId;
    ret.ownerId = friendId;
    ret.albumId = albumId;
    ret.photoId = photoId;
    ret.commentId = fr.elementsByTagName(NODE_PHOTO_COMMENT_ID).at(0).firstChild().toText().data();
    ret.senderId = fr.elementsByTagName(NODE_PHOTO_COMMENT_SENDER_ID).at(0).firstChild().toText().data();
    ret.senderName = fr.elementsByTagName(NODE_PHOTO_COMMENT_SENDER_NAME).at(0).firstChild().toText().data();
    ret.text = fr.elementsByTagName(NODE_PHOTO_COMMENT_TEXT).at(0).firstChild().toText().data();
    ret.time = fr.elementsByTagName(NODE_PHOTO_COMMENT_TIME).at(0).firstChild().toText().data();

    return ret;
}

QDomElement PhotoComment::toQDomElement(QDomDocument doc) {
    return PhotoComment::toQDomElement(doc, *this);
}

QDomElement PhotoComment::toQDomElement(QDomDocument doc, PhotoComment src)
{
    QDomElement ret = doc.createElement(NODE_PHOTO_COMMENT_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_PHOTO_COMMENT_ID);
    QDomText t = doc.createTextNode(src.commentId);
    ret.appendChild(node);
    node.appendChild(t);

    //sender id
    node = doc.createElement(NODE_PHOTO_COMMENT_SENDER_ID);
    t = doc.createTextNode(src.senderId);
    ret.appendChild(node);
    node.appendChild(t);

    //sender name
    node = doc.createElement(NODE_PHOTO_COMMENT_SENDER_NAME);
    t = doc.createTextNode(src.senderName);
    ret.appendChild(node);
    node.appendChild(t);

    //time
    node = doc.createElement(NODE_PHOTO_COMMENT_TIME);
    t = doc.createTextNode(src.time);
    ret.appendChild(node);
    node.appendChild(t);

    //text
    node = doc.createElement(NODE_PHOTO_COMMENT_TEXT);
    t = doc.createTextNode(src.text);
    ret.appendChild(node);
    node.appendChild(t);

    return ret;
}

PhotoComment& PhotoComment::operator =(PhotoComment const& src)
{
    PhotoComment::copyData(this, &src);

    return *this;
}
